/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private Map<Position, IDocumentElementNode> fPositionToElement = new HashMap<Position, IDocumentElementNode>();

    public L10nFoldingStructureProvider(MTJSourcePage mTJSourcePage, IEditingModel iEditingModel) {
        super(mTJSourcePage, iEditingModel);
    }

    @Override
    public void addFoldingRegions(Set<Position> set, IEditingModel iEditingModel) throws BadLocationException {
        L10nLocales l10nLocales = ((L10nModel)iEditingModel).getLocales();
        List list = l10nLocales.getChildren();
        IDocumentElementNode[] iDocumentElementNodeArray = list.toArray(new IDocumentElementNode[list.size()]);
        this.addFoldingRegions(set, iDocumentElementNodeArray, iEditingModel.getDocument());
    }

    private void addFoldingRegions(Set<Position> set, IDocumentElementNode[] iDocumentElementNodeArray, IDocument iDocument) throws BadLocationException {
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray;
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode[] iDocumentElementNodeArray3;
            int n3;
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            int n4 = iDocument.getLineOfOffset(iDocumentElementNode.getOffset());
            if (n4 < (n3 = iDocument.getLineOfOffset(iDocumentElementNode.getOffset() + iDocumentElementNode.getLength()))) {
                int n5 = iDocument.getLineOffset(n4);
                int n6 = iDocument.getLineOffset(n3) + iDocument.getLineLength(n3);
                Position position = new Position(n5, n6 - n5);
                set.add(position);
                this.fPositionToElement.put(position, iDocumentElementNode);
            }
            if ((iDocumentElementNodeArray3 = iDocumentElementNode.getChildNodes()) != null) {
                this.addFoldingRegions(set, iDocumentElementNodeArray3, iDocument);
            }
            ++n2;
        }
    }
}

