/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.AbstractEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "l10n-context";

    public L10nInputContext(MTJFormEditor mTJFormEditor, IEditorInput iEditorInput, boolean bl) {
        super(mTJFormEditor, iEditorInput, bl);
        this.create();
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        AbstractEditingModel abstractEditingModel = (AbstractEditingModel)this.getModel();
        abstractEditingModel.reconciled(abstractEditingModel.getDocument());
    }

    @Override
    protected IBaseModel createModel(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IStorageEditorInput) {
            boolean bl = iEditorInput instanceof IFileEditorInput;
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)iEditorInput);
            L10nModel l10nModel = new L10nModel(iDocument, bl);
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                l10nModel.setUnderlyingResource((IResource)iFile);
                l10nModel.setCharset(iFile.getCharset());
            } else if (iEditorInput instanceof SystemFileEditorInput) {
                File file = (File)((SystemFileEditorInput)iEditorInput).getAdapter(File.class);
                l10nModel.setInstallLocation(file.getParent());
                l10nModel.setCharset(this.getDefaultCharset());
            } else {
                l10nModel.setCharset(this.getDefaultCharset());
            }
            l10nModel.load();
            return l10nModel;
        }
        return null;
    }

    @Override
    protected String getDefaultCharset() {
        return "ISO-8859-1";
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected String getPartitionName() {
        return "___l10n_partition";
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> arrayList) {
    }
}

