/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.KeystoreEntryDialog;
import org.eclipse.mtj.internal.ui.dialog.NewKeyPairDialog;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SigningBlock {
    private TableViewer viewer;
    private Table table;
    private Button aliasGroupBtn1;
    private Button aliasGroupBtn2;
    private Button aliasGroupBtn3;
    private Button aliasGroupBtn4;
    private Button aliasGroupBtn5;
    private Text keyDataText;
    private Text providerText;
    private Text ksTypeText;

    public void createBlock(Composite composite) {
        this.createKeyAliasSection(composite);
        this.createAdvancedSection(composite);
    }

    public void setInput(IKeyStoreManager iKeyStoreManager) {
        this.viewer.setInput((Object)iKeyStoreManager);
        this.updateButtonsAvailability();
        this.keyDataText.setText("");
    }

    public void setEnabled(boolean bl) {
        this.providerText.setEnabled(bl);
        this.keyDataText.setEnabled(bl);
        this.ksTypeText.setEnabled(bl);
        this.table.setEnabled(bl);
        this.updateButtonsAvailability();
    }

    public void clearFields() {
        this.providerText.setText("");
        this.keyDataText.setText("");
        this.ksTypeText.setText("");
    }

    private void updateButtonsAvailability() {
        if (this.viewer.getInput() != null) {
            this.aliasGroupBtn1.setEnabled(true);
            this.aliasGroupBtn4.setEnabled(true);
            if (this.viewer.getSelection().isEmpty()) {
                this.aliasGroupBtn2.setEnabled(false);
                this.aliasGroupBtn3.setEnabled(false);
                this.aliasGroupBtn5.setEnabled(false);
            } else {
                this.aliasGroupBtn2.setEnabled(true);
                this.aliasGroupBtn3.setEnabled(true);
                this.aliasGroupBtn5.setEnabled(true);
            }
        } else {
            this.aliasGroupBtn1.setEnabled(false);
            this.aliasGroupBtn2.setEnabled(false);
            this.aliasGroupBtn3.setEnabled(false);
            this.aliasGroupBtn4.setEnabled(false);
            this.aliasGroupBtn5.setEnabled(false);
        }
    }

    private void createKeyAliasSection(final Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        group.setLayout((Layout)gridLayout);
        group.setText(MTJUIMessages.SigningBlock_keyAliases);
        this.table = new Table((Composite)group, 2052);
        GridData gridData = MTJUIPlugin.buildGridData(4, 4, true, true);
        gridData.verticalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new SigningBlockContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SigningBlockLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                SigningBlock.this.updateButtonsAvailability();
                if (!(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
                    return;
                }
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                if (!(object instanceof KeyStoreEntry)) {
                    return;
                }
                KeyStoreEntry keyStoreEntry = (KeyStoreEntry)object;
                SigningBlock.this.displayKeyData(keyStoreEntry);
            }
        });
        this.aliasGroupBtn1 = new Button((Composite)group, 0);
        this.aliasGroupBtn1.setText(MTJUIMessages.SigningBlock_createNewKeypair);
        this.aliasGroupBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn1.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                NewKeyPairDialog newKeyPairDialog = new NewKeyPairDialog(composite.getShell());
                newKeyPairDialog.setTitle(MTJUIMessages.SigningBlock_generateKeyPair);
                if (newKeyPairDialog.open() != 0) {
                    return;
                }
                Object object = SigningBlock.this.viewer.getInput();
                if (!(object instanceof IKeyStoreManager)) {
                    return;
                }
                IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
                try {
                    iKeyStoreManager.generateKeyPair(newKeyPairDialog.getKeyPairInfo());
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        this.aliasGroupBtn2 = new Button((Composite)group, 0);
        this.aliasGroupBtn2.setText(MTJUIMessages.SigningBlock_deleteKeyPair);
        this.aliasGroupBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn2.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                Object object = SigningBlock.this.viewer.getInput();
                if (!(object instanceof IKeyStoreManager)) {
                    return;
                }
                ISelection iSelection = SigningBlock.this.viewer.getSelection();
                if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
                    return;
                }
                IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
                try {
                    iKeyStoreManager.deleteEntry((KeyStoreEntry)((IStructuredSelection)iSelection).getFirstElement());
                    SigningBlock.this.keyDataText.setText("");
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        this.aliasGroupBtn3 = new Button((Composite)group, 0);
        this.aliasGroupBtn3.setText(MTJUIMessages.SigningBlock_generateCSR);
        this.aliasGroupBtn3.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn3.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                Object object = SigningBlock.this.viewer.getInput();
                if (!(object instanceof IKeyStoreManager)) {
                    return;
                }
                ISelection iSelection = SigningBlock.this.viewer.getSelection();
                if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
                    return;
                }
                DirectoryDialog directoryDialog = new DirectoryDialog(composite.getShell(), 8192);
                directoryDialog.setMessage(MTJUIMessages.SigningBlock_selectCSRFolder);
                String string = directoryDialog.open();
                if (string == null) {
                    return;
                }
                IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
                try {
                    String string2 = (String)((IStructuredSelection)iSelection).getFirstElement();
                    SigningPasswordDialog signingPasswordDialog = new SigningPasswordDialog(composite.getShell(), false);
                    signingPasswordDialog.setTitle(MTJUIMessages.SigningBlock_enterKeyPassword);
                    signingPasswordDialog.setDescription(NLS.bind((String)MTJUIMessages.SigningBlock_enterKeyPasswordForAlias, (Object)string2));
                    if (signingPasswordDialog.open() != 0) {
                        return;
                    }
                    string = NLS.bind((String)"{0}{1}{2}.csr", (Object[])new String[]{string, File.separator, string2});
                    iKeyStoreManager.generateCSR(string2, signingPasswordDialog.getPassword(), string);
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        this.aliasGroupBtn4 = new Button((Composite)group, 0);
        this.aliasGroupBtn4.setText(MTJUIMessages.SigningBlock_importCertificate);
        this.aliasGroupBtn4.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn4.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                Object object = SigningBlock.this.viewer.getInput();
                if (!(object instanceof IKeyStoreManager)) {
                    return;
                }
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*"});
                fileDialog.setText(MTJUIMessages.SigningBlock_importCertificate);
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
                try {
                    KeystoreEntryDialog keystoreEntryDialog = new KeystoreEntryDialog(composite.getShell());
                    keystoreEntryDialog.setTitle(MTJUIMessages.SigningBlock_selectCertificateFile);
                    if (keystoreEntryDialog.open() != 0) {
                        return;
                    }
                    iKeyStoreManager.importCertificate(keystoreEntryDialog.getAlias(), keystoreEntryDialog.getPassword(), string);
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        this.aliasGroupBtn5 = new Button((Composite)group, 0);
        this.aliasGroupBtn5.setText(MTJUIMessages.SigningBlock_importCSRResponse);
        this.aliasGroupBtn5.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn5.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
                Object object = SigningBlock.this.viewer.getInput();
                if (!(object instanceof IKeyStoreManager)) {
                    return;
                }
                String string = null;
                ISelection iSelection = SigningBlock.this.viewer.getSelection();
                if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
                    string = (String)((IStructuredSelection)iSelection).getFirstElement();
                }
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*"});
                fileDialog.setText(MTJUIMessages.SigningBlock_importCertificateReply);
                String string2 = fileDialog.open();
                if (string2 == null) {
                    return;
                }
                IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
                try {
                    KeystoreEntryDialog keystoreEntryDialog = new KeystoreEntryDialog(composite.getShell(), string);
                    keystoreEntryDialog.setTitle(MTJUIMessages.SigningBlock_selectCertificateFile);
                    if (keystoreEntryDialog.open() != 0) {
                        return;
                    }
                    string = keystoreEntryDialog.getAlias();
                    iKeyStoreManager.importCertificate(string, keystoreEntryDialog.getPassword(), string2);
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    MessageDialog.openError((Shell)composite.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)keyStoreManagerException.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setText(MTJUIMessages.SigningBlock_keyData);
        gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.keyDataText = new Text((Composite)group, 2122);
        gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 50;
        this.keyDataText.setLayoutData((Object)gridData);
        this.updateButtonsAvailability();
    }

    protected void displayKeyData(KeyStoreEntry keyStoreEntry) {
        Object object = this.viewer.getInput();
        if (object == null || !(object instanceof IKeyStoreManager)) {
            return;
        }
        IKeyStoreManager iKeyStoreManager = (IKeyStoreManager)object;
        String string = null;
        try {
            string = iKeyStoreManager.getCertificateInformation(keyStoreEntry);
            if (string == null) {
                string = MTJUIMessages.SigningBlock_infoNotAvailable;
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            string = MTJUIMessages.SigningBlock_unableToReadCertInfo;
            MTJLogger.log((int)4, (Throwable)keyStoreManagerException);
        }
        this.keyDataText.setText(string);
    }

    private void createAdvancedSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(MTJUIMessages.SigningBlock_advancedSettings);
        Label label = new Label((Composite)group, 0);
        label.setText(MTJUIMessages.SigningBlock_useJavaSystemDefaults);
        label.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(MTJUIMessages.SigningBlock_cryptoProvider);
        label2.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.providerText = new Text((Composite)group, 2048);
        this.providerText.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(MTJUIMessages.SigningBlock_ksType);
        label3.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.ksTypeText = new Text((Composite)group, 2048);
        this.ksTypeText.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
    }

    public String getCurrentAlias() {
        Object object;
        String string = null;
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty() && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof String) {
            string = (String)object;
        }
        return string;
    }

    public void setCurrentAlias(String string) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)string));
    }

    public String getProvider() {
        String string = this.providerText.getText();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public void setProvider(String string) {
        if (string != null) {
            this.providerText.setText(string);
        } else {
            this.providerText.setText("");
        }
    }

    public String getKeystoreType() {
        String string = this.ksTypeText.getText();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public void setKeystoreType(String string) {
        if (string != null) {
            this.ksTypeText.setText(string);
        } else {
            this.ksTypeText.setText("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PasswordType {
        Prompt,
        Project,
        Workspace;

    }

    private class SigningBlockContentProvider
    implements IStructuredContentProvider {
        private Viewer viewer;

        private SigningBlockContentProvider() {
        }

        public Object[] getElements(Object object) {
            ArrayList arrayList = new ArrayList();
            if (object instanceof IKeyStoreManager) {
                try {
                    arrayList.addAll(((IKeyStoreManager)object).getEntries());
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    String string = NLS.bind((String)MTJUIMessages.SigningBlock_unableToGetKsAliases, (Object)keyStoreManagerException.getMessage());
                    MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)string);
                    MTJLogger.log((int)4, (Throwable)keyStoreManagerException);
                }
            }
            return arrayList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.viewer = viewer;
        }
    }

    private class SigningBlockLabelProvider
    extends LabelProvider {
        private SigningBlockLabelProvider() {
        }

        public String getText(Object object) {
            String string = null;
            if (object instanceof KeyStoreEntry) {
                KeyStoreEntry keyStoreEntry = (KeyStoreEntry)object;
                string = keyStoreEntry.getAlias();
            }
            return string;
        }
    }
}

