/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.parts;

import org.eclipse.mtj.internal.ui.parts.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SharedPartWithButtons
extends SharedPart {
    private String[] fButtonLabels;
    private Button[] fButtons;
    protected Composite fButtonContainer;

    public SharedPartWithButtons(String[] stringArray) {
        this.fButtonLabels = stringArray;
    }

    public void createControl(Composite composite, int n, int n2, FormToolkit formToolkit) {
        this.createMainLabel(composite, n2, formToolkit);
        this.createMainControl(composite, n, n2 - 1, formToolkit);
        this.createButtons(composite, formToolkit);
    }

    public Button getButton(int n) {
        if (this.fButtons == null || n < 0 || n >= this.fButtons.length) {
            return null;
        }
        return this.fButtons[n];
    }

    public void setButtonEnabled(int n, boolean bl) {
        if (this.fButtons != null && n >= 0 && this.fButtons.length > n) {
            this.fButtons[n].setEnabled(bl);
        }
    }

    public void setButtonVisible(int n, boolean bl) {
        if (this.fButtons != null && n >= 0 && this.fButtons.length > n) {
            this.fButtons[n].setVisible(bl);
        }
    }

    protected abstract void buttonSelected(Button var1, int var2);

    protected Button createButton(Composite composite, String string, int n, FormToolkit formToolkit) {
        Button button;
        if (formToolkit != null) {
            button = formToolkit.createButton(composite, string, 8);
        } else {
            button = new Button(composite, 8);
            button.setText(string);
        }
        GridData gridData = new GridData(770);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(n));
        return button;
    }

    protected void createButtons(Composite composite, FormToolkit formToolkit) {
        if (this.fButtonLabels != null && this.fButtonLabels.length > 0) {
            this.fButtonContainer = this.createComposite(composite, formToolkit);
            GridData gridData = new GridData(1040);
            this.fButtonContainer.setLayoutData((Object)gridData);
            this.fButtonContainer.setLayout((Layout)this.createButtonsLayout());
            this.fButtons = new Button[this.fButtonLabels.length];
            SelectionHandler selectionHandler = new SelectionHandler();
            int n = 0;
            while (n < this.fButtonLabels.length) {
                String string = this.fButtonLabels[n];
                if (string != null) {
                    Button button = this.createButton(this.fButtonContainer, string, n, formToolkit);
                    button.addSelectionListener((SelectionListener)selectionHandler);
                    this.fButtons[n] = button;
                } else {
                    this.createEmptySpace(this.fButtonContainer, 1, formToolkit);
                }
                ++n;
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected void createMainLabel(Composite composite, int n, FormToolkit formToolkit) {
    }

    protected void updateEnabledState() {
        Button[] buttonArray = this.fButtons;
        int n = this.fButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setEnabled(this.isEnabled());
            ++n2;
        }
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.buttonSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.buttonSelected(selectionEvent);
        }

        private void buttonSelected(SelectionEvent selectionEvent) {
            Integer n = (Integer)selectionEvent.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)selectionEvent.widget, n);
        }
    }
}

