/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.util.ImageOverlayIcon;
import org.eclipse.mtj.internal.ui.util.OverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SharedLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int F_BINARY = 16;
    public static final int F_EDIT = 8;
    public static final int F_ERROR = 1;
    public static final int F_EXPORT = 4;
    public static final int F_EXTERNAL = 32;
    public static final int F_FRIEND = 2048;
    public static final int F_INTERNAL = 1024;
    public static final int F_JAR = 128;
    public static final int F_JAVA = 64;
    public static final int F_OPTIONAL = 512;
    public static final int F_PROJECT = 256;
    public static final int F_WARNING = 2;
    private Image fBlankImage;
    ArrayList<Object> consumers = new ArrayList();
    Hashtable<Object, Image> images = new Hashtable();

    public void connect(Object object) {
        if (!this.consumers.contains(object)) {
            this.consumers.add(object);
        }
    }

    public void disconnect(Object object) {
        this.consumers.remove(object);
        if (this.consumers.size() == 0) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.consumers.size() == 0) {
            Enumeration<Image> enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().dispose();
            }
            this.images.clear();
            if (this.fBlankImage != null) {
                this.fBlankImage.dispose();
                this.fBlankImage = null;
            }
        }
    }

    public Image get(Image image, int n) {
        if (n == 0) {
            return image;
        }
        String string = this.getKey(image.hashCode(), n);
        Image image2 = this.images.get(string);
        if (image2 == null) {
            image2 = this.createImage(image, n);
            this.images.put(string, image2);
        }
        return image2;
    }

    public Image get(ImageDescriptor imageDescriptor) {
        return this.get(imageDescriptor, 0);
    }

    public Image get(ImageDescriptor imageDescriptor, int n) {
        Image image;
        Object object = imageDescriptor;
        if (n != 0) {
            object = this.getKey(imageDescriptor.hashCode(), n);
        }
        if ((image = this.images.get(object)) == null) {
            image = this.createImage(imageDescriptor, n);
            this.images.put(object, image);
        }
        return image;
    }

    public Image getBlankImage() {
        if (this.fBlankImage == null) {
            this.fBlankImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.fBlankImage;
    }

    public Image getColumnImage(Object object, int n) {
        return this.getImage(object);
    }

    public String getColumnText(Object object, int n) {
        return this.getText(object);
    }

    public Image getImageFromPlugin(String string, String string2) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)string, (String)string2);
        return imageDescriptor != null ? this.get(imageDescriptor) : this.getBlankImage();
    }

    private Image createImage(Image image, int n) {
        if (n == 0) {
            return image;
        }
        ImageDescriptor[] imageDescriptorArray = this.getLowerLeftOverlays(n);
        ImageDescriptor[] imageDescriptorArray2 = this.getUpperRightOverlays(n);
        ImageDescriptor[] imageDescriptorArray3 = this.getLowerRightOverlays(n);
        ImageDescriptor[] imageDescriptorArray4 = this.getUpperLeftOverlays(n);
        ImageOverlayIcon imageOverlayIcon = new ImageOverlayIcon(image, new ImageDescriptor[][]{imageDescriptorArray2, imageDescriptorArray3, imageDescriptorArray, imageDescriptorArray4});
        return imageOverlayIcon.createImage();
    }

    private Image createImage(ImageDescriptor imageDescriptor, int n) {
        if (n == 0) {
            return imageDescriptor.createImage();
        }
        ImageDescriptor[] imageDescriptorArray = this.getLowerLeftOverlays(n);
        ImageDescriptor[] imageDescriptorArray2 = this.getUpperRightOverlays(n);
        ImageDescriptor[] imageDescriptorArray3 = this.getLowerRightOverlays(n);
        ImageDescriptor[] imageDescriptorArray4 = this.getUpperLeftOverlays(n);
        OverlayIcon overlayIcon = new OverlayIcon(imageDescriptor, new ImageDescriptor[][]{imageDescriptorArray2, imageDescriptorArray3, imageDescriptorArray, imageDescriptorArray4});
        return overlayIcon.createImage();
    }

    private String getKey(long l, int n) {
        return l + ":" + n;
    }

    private ImageDescriptor[] getLowerLeftOverlays(int n) {
        if ((n & 1) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_ERROR_CO};
        }
        if ((n & 2) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_WARNING_CO};
        }
        return null;
    }

    private ImageDescriptor[] getLowerRightOverlays(int n) {
        if ((n & 0x80) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_JAR_CO};
        }
        if ((n & 0x100) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_PROJECT_CO};
        }
        if ((n & 0x200) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_OPTIONAL_CO};
        }
        if ((n & 0x400) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_INTERNAL_CO};
        }
        if ((n & 0x800) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_FRIEND_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperLeftOverlays(int n) {
        if ((n & 0x20) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_EXTERNAL_CO};
        }
        if ((n & 0x10) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_BINARY_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperRightOverlays(int n) {
        if ((n & 4) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_EXPORT_CO};
        }
        if ((n & 8) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_DOC_CO};
        }
        if ((n & 0x40) != 0) {
            return new ImageDescriptor[]{MTJUIPluginImages.DESC_JAVA_CO};
        }
        return null;
    }
}

