/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core.action;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.mtj.internal.pulsar.core.Messages;
import org.eclipse.mtj.internal.pulsar.core.action.execution.ExecutionFactory;
import org.eclipse.mtj.internal.pulsar.core.action.execution.ExecutionHandler;
import org.eclipse.mtj.pulsar.core.Activator;

public class ExecuteAction
extends ProvisioningAction {
    public static final String ACTION_EXECUTE = "execute";
    private static final String PARM_EXECUTABLE = "executable";

    public IStatus execute(Map map) {
        IFileArtifactRepository iFileArtifactRepository;
        Object object;
        String string = (String)map.get(PARM_EXECUTABLE);
        if (string == null) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ParamNotSetError, PARM_EXECUTABLE, ACTION_EXECUTE), null);
        }
        IInstallableUnit iInstallableUnit = (IInstallableUnit)map.get("iu");
        if (string.equals("@artifact")) {
            object = iInstallableUnit.getArtifacts()[0];
            try {
                iFileArtifactRepository = Util.getDownloadCacheRepo();
            }
            catch (ProvisionException provisionException) {
                return provisionException.getStatus();
            }
            File file = iFileArtifactRepository.getArtifactFile((IArtifactKey)object);
            if (file == null || !file.exists()) {
                return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_MissingArtifactError, object), null);
            }
            string = file.getAbsolutePath();
        }
        try {
            object = ExecutionFactory.getExecutionHandler(System.getProperty("os.name"), string);
            iFileArtifactRepository = ((ExecutionHandler)object).handleExecution();
            if (!iFileArtifactRepository.isOK()) {
                return iFileArtifactRepository;
            }
        }
        catch (Exception exception) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ExecuteError, string), exception);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map map) {
        return Activator.makeErrorStatus(Messages.ExecuteAction_UndoUnsupportedError, null);
    }
}

