/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntimeList
extends ArrayList<MTJRuntime> {
    public static final String ELEM_CONFIGURATIONS = "configurations";
    private static final long serialVersionUID = -8304504334314517586L;
    private List<IMTJRuntimeListChangeListener> listeners = new ArrayList<IMTJRuntimeListChangeListener>();

    public MTJRuntimeList() {
    }

    public MTJRuntimeList(Element element) throws PersistenceException {
        NodeList nodeList = element.getElementsByTagName("configuration");
        int n = 0;
        while (n < nodeList.getLength()) {
            MTJRuntime mTJRuntime = new MTJRuntime((Element)nodeList.item(n));
            this.add(mTJRuntime);
            ++n;
        }
    }

    @Override
    public boolean add(MTJRuntime mTJRuntime) {
        boolean bl = super.add(mTJRuntime);
        if (!bl) {
            return bl;
        }
        AddMTJRuntimeEvent addMTJRuntimeEvent = new AddMTJRuntimeEvent(this, mTJRuntime);
        for (IMTJRuntimeListChangeListener iMTJRuntimeListChangeListener : this.listeners) {
            iMTJRuntimeListChangeListener.mtjRuntimeAdded(addMTJRuntimeEvent);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends MTJRuntime> collection) throws NullPointerException {
        boolean bl = false;
        for (MTJRuntime mTJRuntime : collection) {
            bl = this.add(mTJRuntime);
        }
        return bl;
    }

    public void addMTJRuntimeListChangeListener(IMTJRuntimeListChangeListener iMTJRuntimeListChangeListener) {
        this.listeners.add(iMTJRuntimeListChangeListener);
    }

    public MTJRuntime getActiveMTJRuntime() {
        for (MTJRuntime mTJRuntime : this) {
            if (!mTJRuntime.isActive()) continue;
            return mTJRuntime;
        }
        return null;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (!bl) {
            return bl;
        }
        if (object instanceof MTJRuntime) {
            MTJRuntime mTJRuntime = (MTJRuntime)object;
            RemoveMTJRuntimeEvent removeMTJRuntimeEvent = new RemoveMTJRuntimeEvent(this, mTJRuntime);
            for (IMTJRuntimeListChangeListener iMTJRuntimeListChangeListener : this.listeners) {
                iMTJRuntimeListChangeListener.mtjRuntimeRemoved(removeMTJRuntimeEvent);
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl = this.remove(obj);
        }
        return bl;
    }

    public void removeMTJRuntimeListChangeListener(IMTJRuntimeListChangeListener iMTJRuntimeListChangeListener) {
        this.listeners.remove(iMTJRuntimeListChangeListener);
    }

    public void switchActiveMTJRuntime(MTJRuntime mTJRuntime) {
        MTJRuntime mTJRuntime2 = this.getActiveMTJRuntime();
        if (mTJRuntime2 != null) {
            this.getActiveMTJRuntime().setActive(false);
        }
        mTJRuntime.setActive(true);
        SwitchActiveMTJRuntimeEvent switchActiveMTJRuntimeEvent = new SwitchActiveMTJRuntimeEvent(this, mTJRuntime2, mTJRuntime);
        for (IMTJRuntimeListChangeListener iMTJRuntimeListChangeListener : this.listeners) {
            iMTJRuntimeListChangeListener.activeMTJRuntimeSwitched(switchActiveMTJRuntimeEvent);
        }
    }
}

