/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.mtj.internal.core.refactoring.MidletJadFileChangesCollector;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;

public class MidletRenameParticipant
extends RenameParticipant {
    private IType type;

    protected boolean initialize(Object object) {
        this.type = (IType)object;
        return this.getArguments().getUpdateReferences();
    }

    public String getName() {
        return RefactoringMessages.UpdateApplicationDescriptor_refactoringParticipantName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 5);
        subProgressMonitor.setTaskName("Creating Application Descriptor Changes");
        String string = this.getNewName();
        CompositeChange compositeChange = MidletJadFileChangesCollector.collectChange(1, this.type, string, (IProgressMonitor)subProgressMonitor);
        subProgressMonitor.done();
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    private String getNewName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.type.getPackageFragment().getElementName();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string).append(".");
        }
        stringBuffer.append(this.getArguments().getNewName());
        return stringBuffer.toString();
    }
}

