/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.HashMap;
import org.eclipse.mtj.internal.core.text.DocumentXMLNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.MTJTextHelper;

public class DocumentTextNode
extends DocumentXMLNode
implements IDocumentTextNode {
    private static final long serialVersionUID = 1L;
    protected static final HashMap<Character, String> SUBSTITUTE_CHARS = new HashMap(5);
    private transient IDocumentElementNode fEnclosingElement = null;
    private transient int fLength = 0;
    private transient int fOffset = -1;
    private String fText;

    static {
        SUBSTITUTE_CHARS.put(new Character('&'), "&amp;");
        SUBSTITUTE_CHARS.put(new Character('<'), "&lt;");
        SUBSTITUTE_CHARS.put(new Character('>'), "&gt;");
        SUBSTITUTE_CHARS.put(new Character('\''), "&apos;");
        SUBSTITUTE_CHARS.put(new Character('\"'), "&quot;");
    }

    public IDocumentElementNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public String getText() {
        return this.fText == null ? "" : this.fText;
    }

    public int getXMLType() {
        return 2;
    }

    public void reconnect(IDocumentElementNode iDocumentElementNode) {
        this.fEnclosingElement = iDocumentElementNode;
        this.fLength = -1;
        this.fOffset = -1;
    }

    public void setEnclosingElement(IDocumentElementNode iDocumentElementNode) {
        this.fEnclosingElement = iDocumentElementNode;
    }

    public void setLength(int n) {
        this.fLength = n;
    }

    public void setOffset(int n) {
        this.fOffset = n;
    }

    public void setText(String string) {
        this.fText = string;
    }

    public String write() {
        String string = this.getText().trim();
        return MTJTextHelper.translateWriteText(string, SUBSTITUTE_CHARS);
    }
}

