/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTool {
    public static final String JAVA_APP_LAUNCH_ID = "org.eclipse.jdt.launching.localJavaApplication";
    private static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    private static final IStatus delegateNotAvailable = new Status(1, "org.eclipse.debug.core", 226, "", null);

    protected abstract String[] getArguments();

    protected abstract String getClassName();

    protected abstract String[] getClasspath();

    protected abstract String getName();

    protected abstract String[] getVMArguments();

    public ILaunch launch(IProgressMonitor iProgressMonitor) throws CoreException {
        Launch launch = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager iLaunchManager = debugPlugin.getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(JAVA_APP_LAUNCH_ID);
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getName());
        this.fillLaunchConfig(iLaunchConfigurationWorkingCopy);
        launch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", null);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("run");
        ILaunchDelegate[] iLaunchDelegateArray = iLaunchConfigurationType.getDelegates(hashSet);
        ILaunchConfigurationDelegate iLaunchConfigurationDelegate = null;
        if (iLaunchDelegateArray.length == 1) {
            iLaunchConfigurationDelegate = iLaunchDelegateArray[0].getDelegate();
        } else if (iLaunchDelegateArray.length == 0) {
            IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(promptStatus);
            if (iStatusHandler != null) {
                iStatusHandler.handleStatus(delegateNotAvailable, (Object)new Object[]{this, "run"});
            }
            Status status = new Status(8, DebugPlugin.getUniqueIdentifier(), 4, Messages.AbstractJavaTool_delegateNotAvailable, null);
            throw new CoreException((IStatus)status);
        }
        iLaunchConfigurationDelegate.launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "run", (ILaunch)launch, iProgressMonitor);
        Utils.dumpCommandLine((ILaunch)launch);
        return launch;
    }

    private void fillLaunchConfig(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) throws CoreException {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getClassName());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.getClasspathMementos());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArgumentsString());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgumentsString());
    }

    private String getArgumentsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void addStandardLibraries(List<String> list) throws CoreException {
        LibraryLocation[] libraryLocationArray;
        IVMInstall iVMInstall = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall != null && (libraryLocationArray = JavaRuntime.getLibraryLocations((IVMInstall)iVMInstall)) != null) {
            int n = 0;
            while (n < libraryLocationArray.length) {
                IPath iPath = libraryLocationArray[n].getSystemLibraryPath();
                IRuntimeClasspathEntry iRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)iPath);
                iRuntimeClasspathEntry.setClasspathProperty(1);
                list.add(iRuntimeClasspathEntry.getMemento());
                ++n;
            }
        }
    }

    private List<String> getClasspathMementos() throws CoreException {
        String[] stringArray = this.getClasspath();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            IRuntimeClasspathEntry iRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(string));
            arrayList.add(iRuntimeClasspathEntry.getMemento());
            ++n;
        }
        this.addStandardLibraries(arrayList);
        return arrayList;
    }

    private String getProgramArgumentsString() {
        return this.getArgumentsString(this.getArguments());
    }

    private String getVMArgumentsString() {
        return this.getArgumentsString(this.getVMArguments());
    }
}

