/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.l10n.RegExpStringExternalizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StringLocalizationCandidatesDialog
extends Dialog {
    private ICompilationUnit[] cus;
    private ICompilationUnit cu;
    private ListViewer viewer;

    public StringLocalizationCandidatesDialog(Shell shell, ICompilationUnit[] iCompilationUnitArray) {
        super(shell);
        this.cus = iCompilationUnitArray;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Localize Strings");
    }

    protected Control createDialogArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new ListViewer(composite2, 2820);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                ArrayList<StringOccurences> arrayList = new ArrayList<StringOccurences>();
                if (object instanceof ICompilationUnit[]) {
                    ICompilationUnit[] iCompilationUnitArray = (ICompilationUnit[])object;
                    int n = iCompilationUnitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit iCompilationUnit = iCompilationUnitArray[n2];
                        RegExpStringExternalizer regExpStringExternalizer = new RegExpStringExternalizer();
                        try {
                            IRegion[] iRegionArray = regExpStringExternalizer.externalize(iCompilationUnit.getBuffer(), true);
                            if (iRegionArray.length > 0) {
                                StringOccurences stringOccurences = new StringOccurences();
                                stringOccurences.occurrences = iRegionArray.length;
                                stringOccurences.className = iCompilationUnit.getResource().getFullPath().toString();
                                stringOccurences.cu = iCompilationUnit;
                                arrayList.add(stringOccurences);
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            MTJLogger.log((int)4, (Throwable)javaModelException);
                        }
                        ++n2;
                    }
                }
                return arrayList.toArray(new StringOccurences[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                String string = null;
                if (object instanceof StringOccurences) {
                    StringOccurences stringOccurences = (StringOccurences)object;
                    string = NLS.bind((String)"{0} in {1}", (Object[])new String[]{String.valueOf(stringOccurences.occurrences), stringOccurences.className});
                }
                return string;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = StringLocalizationCandidatesDialog.this.viewer.getSelection();
                if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
                    StringOccurences stringOccurences = (StringOccurences)((IStructuredSelection)iSelection).getFirstElement();
                    StringLocalizationCandidatesDialog.this.cu = stringOccurences.cu;
                }
            }
        });
        this.viewer.setInput((Object)this.cus);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        this.viewer.getList().setLayoutData((Object)gridData);
        return composite2;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (button != null && n == 0) {
            button.setText("Localize...");
        }
        return button;
    }

    public ICompilationUnit getSelectedClass() {
        return this.cu;
    }

    private class StringOccurences {
        public ICompilationUnit cu;
        public String className;
        public int occurrences;

        private StringOccurences() {
        }
    }
}

