/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.IContextPart;
import org.eclipse.mtj.internal.ui.editor.MTJDetails;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSection;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class MTJFormPage
extends FormPage {
    private Control lastFocusControl = null;
    private boolean newStyleHeader = true;
    private boolean stale = false;

    public MTJFormPage(FormEditor formEditor, String string, String string2) {
        super(formEditor, string, string2);
    }

    public MTJFormPage(FormEditor formEditor, String string, String string2, boolean bl) {
        this(formEditor, string, string2);
        this.newStyleHeader = bl;
    }

    public void addLastFocusListeners(Composite composite) {
        Control[] controlArray;
        Control[] controlArray2 = controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control instanceof Text || control instanceof Button || control instanceof Combo || control instanceof CCombo || control instanceof Tree || control instanceof Table || control instanceof Spinner || control instanceof Link || control instanceof List || control instanceof TabFolder || control instanceof CTabFolder || control instanceof Hyperlink || control instanceof FilteredTree) {
                this.addLastFocusListener(control);
            }
            if (control instanceof Composite) {
                this.addLastFocusListeners((Composite)control);
            }
            ++n2;
        }
    }

    public void alignSectionHeaders(Section section, Section section2) {
        section2.descriptionVerticalSpacing += section.getTextClientHeightDifference();
    }

    public void cancelEdit() {
        IFormPart[] iFormPartArray;
        IFormPart[] iFormPartArray2 = iFormPartArray = this.getManagedForm().getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart iFormPart = iFormPartArray2[n2];
            if (iFormPart instanceof IContextPart) {
                ((IContextPart)iFormPart).cancelEdit();
            }
            ++n2;
        }
    }

    public boolean canCopy(ISelection iSelection) {
        AbstractFormPart abstractFormPart = this.getFocusSection();
        if (abstractFormPart != null) {
            if (abstractFormPart instanceof MTJSection) {
                return ((MTJSection)abstractFormPart).canCopy(iSelection);
            }
            if (abstractFormPart instanceof MTJDetails) {
                return ((MTJDetails)abstractFormPart).canCopy(iSelection);
            }
        }
        return false;
    }

    public boolean canCut(ISelection iSelection) {
        AbstractFormPart abstractFormPart = this.getFocusSection();
        if (abstractFormPart != null) {
            if (abstractFormPart instanceof MTJSection) {
                return ((MTJSection)abstractFormPart).canCut(iSelection);
            }
            if (abstractFormPart instanceof MTJDetails) {
                return ((MTJDetails)abstractFormPart).canCut(iSelection);
            }
        }
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        AbstractFormPart abstractFormPart = this.getFocusSection();
        if (abstractFormPart != null) {
            if (abstractFormPart instanceof MTJSection) {
                return ((MTJSection)abstractFormPart).canPaste(clipboard);
            }
            if (abstractFormPart instanceof MTJDetails) {
                return ((MTJDetails)abstractFormPart).canPaste(clipboard);
            }
        }
        return false;
    }

    public void contextMenuAboutToShow(IMenuManager iMenuManager) {
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        IManagedForm iManagedForm = this.getManagedForm();
        if (iManagedForm != null) {
            this.addLastFocusListeners((Composite)iManagedForm.getForm());
        }
    }

    public Section createUISection(Composite composite, String string, String string2, int n) {
        Section section = this.getManagedForm().getToolkit().createSection(composite, n);
        section.clientVerticalSpacing = 6;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setText(string);
        section.setDescription(string2);
        GridData gridData = new GridData(768);
        section.setLayoutData((Object)gridData);
        return section;
    }

    public Composite createUISectionContainer(Composite composite, int n) {
        Composite composite2 = this.getManagedForm().getToolkit().createComposite(composite);
        composite2.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, n));
        return composite2;
    }

    public void dispose() {
        Menu menu;
        Control control = this.getPartControl();
        if (control != null && !control.isDisposed() && (menu = control.getMenu()) != null) {
            this.resetMenu(menu, control);
        }
        super.dispose();
    }

    public Control getLastFocusControl() {
        return this.lastFocusControl;
    }

    public IBaseModel getModel() {
        return this.getMTJEditor().getAggregateModel();
    }

    public MTJFormEditor getMTJEditor() {
        return (MTJFormEditor)this.getEditor();
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    public boolean performGlobalAction(String string) {
        Control control = this.getFocusControl();
        if (control == null) {
            return false;
        }
        if (this.canPerformDirectly(string, control)) {
            return true;
        }
        AbstractFormPart abstractFormPart = this.getFocusSection();
        if (abstractFormPart != null) {
            if (abstractFormPart instanceof MTJSection) {
                return ((MTJSection)abstractFormPart).doGlobalAction(string);
            }
            if (abstractFormPart instanceof MTJDetails) {
                return ((MTJDetails)abstractFormPart).doGlobalAction(string);
            }
        }
        return false;
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl && this.isStale()) {
            this.refresh();
        }
    }

    public void setLastFocusControl(Control control) {
        this.lastFocusControl = control;
    }

    public void updateFormSelection() {
        if (this.lastFocusControl != null && !this.lastFocusControl.isDisposed()) {
            this.lastFocusControl.setFocus();
        } else {
            this.setFocus();
        }
    }

    private void addLastFocusListener(final Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                MTJFormPage.this.lastFocusControl = control;
            }
        });
    }

    private AbstractFormPart getFocusSection() {
        Control control = this.getFocusControl();
        if (control == null) {
            return null;
        }
        Composite composite = control.getParent();
        AbstractFormPart abstractFormPart = null;
        while (composite != null) {
            Object object = composite.getData("part");
            if (object != null && object instanceof AbstractFormPart) {
                abstractFormPart = (AbstractFormPart)object;
                break;
            }
            composite = composite.getParent();
        }
        return abstractFormPart;
    }

    private void resetMenu(Menu menu, Control control) {
        Composite composite;
        if (control instanceof Composite) {
            Control[] controlArray;
            composite = (Composite)control;
            Control[] controlArray2 = controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control2 = controlArray2[n2];
                this.resetMenu(menu, control2);
                ++n2;
            }
        }
        if ((composite = control.getMenu()) != null && composite.equals(menu)) {
            control.setMenu(null);
        }
    }

    protected boolean canPerformDirectly(String string, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (string.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (string.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (string.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (string.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (string.equals(ActionFactory.DELETE.getId())) {
                int n = text.getSelectionCount();
                if (n == 0) {
                    int n2 = text.getCaretPosition();
                    text.setSelection(n2, n2 + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        Object object;
        final ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        if (this.newStyleHeader) {
            formToolkit.decorateFormHeading(scrolledForm.getForm());
        }
        IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
        this.getMTJEditor().contributeToToolbar(iToolBarManager);
        final String string = this.getHelpResource();
        if (string != null) {
            object = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)scrolledForm.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                        }
                    });
                }
            };
            object.setToolTipText(MTJUIMessages.MTJFormPage_helpAction_toolTipText);
            object.setImageDescriptor(MTJUIPluginImages.DESC_HELP);
            iToolBarManager.add((IAction)object);
        }
        IFormPart[] iFormPartArray = object = iManagedForm.getParts();
        int n = ((IFormPart[])object).length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable iAdaptable;
            IAction[] iActionArray;
            IFormPart iFormPart = iFormPartArray[n2];
            if (iFormPart instanceof IAdaptable && (iActionArray = (IAction[])(iAdaptable = (IAdaptable)iFormPart).getAdapter(IAction[].class)) != null) {
                IAction[] iActionArray2 = iActionArray;
                int n3 = iActionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAction iAction = iActionArray2[n4];
                    scrolledForm.getToolBarManager().add(iAction);
                    ++n4;
                }
            }
            ++n2;
        }
        scrolledForm.updateToolBar();
    }

    protected void createFormErrorContent(IManagedForm iManagedForm, String string, String string2) {
        this.createFormErrorContent(iManagedForm, string, string2, null);
    }

    protected void createFormErrorContent(IManagedForm iManagedForm, String string, String string2, Exception exception) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        if (this.newStyleHeader) {
            formToolkit.decorateFormHeading(scrolledForm.getForm());
        }
        Composite composite = scrolledForm.getBody();
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 7;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        scrolledForm.setText(string);
        scrolledForm.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        int n = 384;
        Section section = this.createUISection(composite, MTJUIMessages.MTJFormPage_messageSection_title, string2, n);
        Composite composite2 = this.createUISectionContainer((Composite)section, 1);
        formToolkit.paintBordersFor(composite2);
        section.setClient((Control)composite2);
        if (exception == null) {
            return;
        }
        Section section2 = this.createUISection(composite, MTJUIMessages.MTJFormPage_detailsSection_title, exception.getMessage(), n);
        Composite composite3 = this.createUISectionContainer((Composite)section2, 1);
        int n2 = 778;
        Text text = formToolkit.createText(composite3, this.getStackTrace(exception), n2);
        GridData gridData2 = new GridData(768);
        gridData2.heightHint = 160;
        gridData2.widthHint = 200;
        text.setLayoutData((Object)gridData2);
        formToolkit.paintBordersFor(composite3);
        section2.setClient((Control)composite3);
    }

    protected Control getFocusControl() {
        IManagedForm iManagedForm = this.getManagedForm();
        if (iManagedForm == null) {
            return null;
        }
        ScrolledForm scrolledForm = iManagedForm.getForm();
        if (scrolledForm == null || scrolledForm.isDisposed()) {
            return null;
        }
        Display display = scrolledForm.getDisplay();
        Control control = display.getFocusControl();
        if (control == null || control.isDisposed()) {
            return null;
        }
        return control;
    }

    protected String getHelpResource() {
        return null;
    }

    protected boolean isStale() {
        return this.stale;
    }

    protected void markStale() {
        this.stale = true;
    }

    protected void refresh() {
        this.stale = false;
    }
}

