/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.text.AnnotationHover;
import org.eclipse.mtj.internal.ui.editor.text.BaseMTJScanner;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.MTJQuickAssistAssistant;
import org.eclipse.mtj.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.mtj.internal.ui.editor.text.XMLDoubleClickStrategy;
import org.eclipse.mtj.internal.ui.editor.text.XMLScanner;
import org.eclipse.mtj.internal.ui.editor.text.XMLTagScanner;
import org.eclipse.swt.graphics.Color;

public class XMLConfiguration
extends ChangeAwareSourceViewerConfiguration {
    private AnnotationHover fAnnotationHover;
    private MultilineDamagerRepairer fDamagerRepairer;
    private XMLDoubleClickStrategy fDoubleClickStrategy;
    private XMLScanner fPdeScanner;
    private MTJQuickAssistAssistant fQuickAssistant;
    private XMLTagScanner fTagScanner;
    private TextAttribute fXMLCommentAttr;

    public XMLConfiguration(IColorManager iColorManager) {
        this(iColorManager, null);
    }

    public XMLConfiguration(IColorManager iColorManager, MTJSourcePage mTJSourcePage) {
        super(mTJSourcePage, iColorManager);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fTagScanner == null) {
            return;
        }
        if (this.affectsColorPresentation(propertyChangeEvent)) {
            this.fColorManager.handlePropertyChangeEvent(propertyChangeEvent);
        }
        this.fTagScanner.adaptToPreferenceChange(propertyChangeEvent);
        this.fPdeScanner.adaptToPreferenceChange(propertyChangeEvent);
        String string = propertyChangeEvent.getProperty();
        if (string.startsWith("editor.color.xml_comment")) {
            this.adaptTextAttribute(propertyChangeEvent);
        }
    }

    public boolean affectsColorPresentation(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        return string.equals("editor.color.default") || string.equals("editor.color.instr") || string.equals("editor.color.string") || string.equals("editor.color.tag") || string.equals("editor.color.xml_comment");
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        return string.startsWith("editor.color.default") || string.startsWith("editor.color.instr") || string.startsWith("editor.color.string") || string.startsWith("editor.color.tag") || string.startsWith("editor.color.xml_comment");
    }

    public void dispose() {
        if (this.fQuickAssistant != null) {
            this.fQuickAssistant.dispose();
        }
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationHover();
        }
        return this.fAnnotationHover;
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        return "_mtj_xml_partitioning";
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning("_mtj_xml_partitioning");
        MultilineDamagerRepairer multilineDamagerRepairer = new MultilineDamagerRepairer((ITokenScanner)this.getMTJScanner());
        presentationReconciler.setDamager((IPresentationDamager)multilineDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)multilineDamagerRepairer, "__dftl_partition_content_type");
        multilineDamagerRepairer = new MultilineDamagerRepairer((ITokenScanner)this.getMTJTagScanner());
        presentationReconciler.setDamager((IPresentationDamager)multilineDamagerRepairer, "__xml_tag");
        presentationReconciler.setRepairer((IPresentationRepairer)multilineDamagerRepairer, "__xml_tag");
        this.fXMLCommentAttr = BaseMTJScanner.createTextAttribute(this.fColorManager, "editor.color.xml_comment");
        this.fDamagerRepairer = new MultilineDamagerRepairer(null, this.fXMLCommentAttr);
        presentationReconciler.setDamager((IPresentationDamager)this.fDamagerRepairer, "__xml_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)this.fDamagerRepairer, "__xml_comment");
        return presentationReconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer iSourceViewer) {
        if (iSourceViewer.isEditable()) {
            if (this.fQuickAssistant == null) {
                this.fQuickAssistant = new MTJQuickAssistAssistant();
            }
            return this.fQuickAssistant;
        }
        return null;
    }

    private void adaptTextAttribute(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        this.fXMLCommentAttr = string.endsWith("_bold") ? this.adaptToStyleChange(propertyChangeEvent, 1, this.fXMLCommentAttr) : (string.endsWith("_italic") ? this.adaptToStyleChange(propertyChangeEvent, 2, this.fXMLCommentAttr) : new TextAttribute(this.fColorManager.getColor(propertyChangeEvent.getProperty()), this.fXMLCommentAttr.getBackground(), this.fXMLCommentAttr.getStyle()));
        this.fDamagerRepairer.setDefaultTextAttribute(this.fXMLCommentAttr);
    }

    private TextAttribute adaptToStyleChange(PropertyChangeEvent propertyChangeEvent, int n, TextAttribute textAttribute) {
        boolean bl;
        boolean bl2 = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        boolean bl3 = bl = (textAttribute.getStyle() & n) == n;
        if (bl != bl2) {
            Color color = textAttribute.getForeground();
            Color color2 = textAttribute.getBackground();
            int n2 = bl2 ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n;
            textAttribute = new TextAttribute(color, color2, n2);
        }
        return textAttribute;
    }

    protected int getInfoImplementationType() {
        return 1;
    }

    protected XMLScanner getMTJScanner() {
        if (this.fPdeScanner == null) {
            this.fPdeScanner = new XMLScanner(this.fColorManager);
        }
        return this.fPdeScanner;
    }

    protected XMLTagScanner getMTJTagScanner() {
        if (this.fTagScanner == null) {
            this.fTagScanner = new XMLTagScanner(this.fColorManager);
        }
        return this.fTagScanner;
    }
}

