/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2MEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.J2MEPreferencePage";
    private IntegerFieldEditor dbgServPoll;
    private IntegerFieldEditor dbgTimeOut;
    private StringFieldEditor deploymentDirectory;

    public J2MEPreferencePage() {
        super(1);
        this.setPreferenceStore(MTJUIPlugin.getDefault().getCorePreferenceStore());
        this.setDescription(MTJUIMessages.J2MEPreferencePage_description);
    }

    public void createFieldEditors() {
        int n = 3;
        Composite composite = this.getFieldEditorParent();
        this.deploymentDirectory = new StringFieldEditor("deployment_dir", MTJUIMessages.J2MEPreferencePage_deployment_directory, composite);
        this.deploymentDirectory.setErrorMessage(String.valueOf(this.deploymentDirectory.getLabelText()) + " " + this.deploymentDirectory.getErrorMessage());
        this.addField((FieldEditor)this.deploymentDirectory);
        this.addSpacer(composite, n);
        Group group = new Group(composite, 0);
        group.setText(MTJUIMessages.J2MEPreferencePage_antenna_settings);
        group.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = this.getColumnSpanGridData(n);
        gridData.minimumWidth = 500;
        group.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(3, true));
        composite2.setLayoutData((Object)new GridData(1808));
        FileFieldEditor fileFieldEditor = new FileFieldEditor("antenna_jar", MTJUIMessages.J2MEPreferencePage_antenna_JAR, true, composite2);
        fileFieldEditor.setFileExtensions(new String[]{"*.jar"});
        this.addField((FieldEditor)fileFieldEditor);
        DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("wtk_root", MTJUIMessages.J2MEPreferencePage_WTK_root, composite2);
        this.addField((FieldEditor)directoryFieldEditor);
        this.addSpacer(composite, n);
        Group group2 = new Group(composite, 0);
        group2.setText(MTJUIMessages.J2MEPreferencePage_proguard_settings);
        group2.setLayout((Layout)new GridLayout(1, true));
        GridData gridData2 = this.getColumnSpanGridData(n);
        gridData2.minimumWidth = 500;
        group2.setLayoutData((Object)gridData2);
        Composite composite3 = new Composite((Composite)group2, 0);
        composite3.setLayout((Layout)new GridLayout(3, true));
        composite3.setLayoutData((Object)new GridData(1808));
        this.addField((FieldEditor)new ProguardDirectoryFieldEditor("proguard_dir", MTJUIMessages.ObfuscationPreferencePage_proguard_root_directory, composite3));
        this.addSpacer(composite, n);
        this.dbgTimeOut = new IntegerFieldEditor("rmt_debug_delay", MTJUIMessages.J2MEPreferencePage_debug_server_time_out, composite);
        this.dbgTimeOut.setErrorMessage(String.valueOf(this.dbgTimeOut.getLabelText()) + MTJUIMessages.J2MEPreferencePage_0 + this.dbgTimeOut.getErrorMessage());
        this.addField((FieldEditor)this.dbgTimeOut);
        this.dbgServPoll = new IntegerFieldEditor("rmt_debug_poll_interval", MTJUIMessages.J2MEPreferencePage_debug_server_poll_interval, composite);
        this.dbgServPoll.setErrorMessage(String.valueOf(this.dbgServPoll.getLabelText()) + " " + this.dbgServPoll.getErrorMessage());
        this.addField((FieldEditor)this.dbgServPoll);
        Label label = new Label(composite, 0);
        label.setText(MTJUIMessages.J2MEPreferencePage_maximum_duration_launch);
        label.setLayoutData((Object)this.getColumnSpanGridData(n));
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        boolean bl = this.dbgServPoll.isValid();
        boolean bl2 = this.dbgTimeOut.isValid();
        boolean bl3 = Utils.isValidFolderName((String)this.deploymentDirectory.getStringValue());
        if (!(bl3 && bl && bl2)) {
            if (!bl3) {
                this.setErrorMessage(this.deploymentDirectory.getErrorMessage());
                this.setValid(Utils.isValidFolderName((String)this.deploymentDirectory.getStringValue()));
            }
            if (!bl) {
                this.setErrorMessage(this.dbgServPoll.getErrorMessage());
            } else if (!bl2) {
                this.setErrorMessage(this.dbgTimeOut.getErrorMessage());
            }
        } else {
            this.setValid(true);
        }
    }

    private void addSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)this.getColumnSpanGridData(n));
    }

    private GridData getColumnSpanGridData(int n) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        return gridData;
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_J2MEPreferencePage");
        return super.createContents(composite);
    }

    private class ProguardDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public ProguardDirectoryFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        private boolean isProguardFolder(File file) {
            String string = NLS.bind((String)"lib{0}proguard.jar", (Object)File.separator);
            File file2 = new File(file, string);
            return file2.exists();
        }

        protected boolean doCheckState() {
            boolean bl = false;
            File file = null;
            String string = null;
            string = this.getStringValue();
            if (string != null && string.trim().length() > 0) {
                file = new File(string);
                if (file.isDirectory()) {
                    if (this.isProguardFolder(file)) {
                        bl = true;
                    } else {
                        this.setErrorMessage(NLS.bind((String)MTJUIMessages.ObfuscationPreferencePage_couldNotFindProguardJAr, (Object)file.getAbsolutePath()));
                    }
                } else {
                    this.setErrorMessage(MTJUIMessages.ObfuscationPreferencePage_NotAFolder);
                }
            } else {
                bl = true;
            }
            return bl;
        }
    }
}

