/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilderVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private IMidletSuiteProject suiteProject;
    private MTJBuildProperties properties;
    private List<IFile> resources = new ArrayList<IFile>();
    private List<IFile> classes = new ArrayList<IFile>();
    private de.schlichtherle.io.File jar;

    public PackageBuilderVisitor(IMidletSuiteProject iMidletSuiteProject, de.schlichtherle.io.File file) {
        this.properties = MTJBuildProperties.getBuildProperties(iMidletSuiteProject);
        this.suiteProject = iMidletSuiteProject;
        this.jar = file;
    }

    public boolean visit(IResource iResource) throws CoreException {
        IFile iFile;
        if (iResource instanceof IFile && this.isOnBuildFolder(iFile = (IFile)iResource)) {
            if (iFile.getName().endsWith(".class")) {
                IFile iFile2 = this.getPreVerifiedClassFile(iFile);
                if (iFile2 != null) {
                    if (this.isOnBuildProperties((IResource)iFile, true)) {
                        this.classes.add(iFile2);
                    } else {
                        this.removeFromJAR(iFile2);
                    }
                }
            } else if (this.isOnBuildProperties(iResource, false)) {
                this.resources.add(iFile);
            } else {
                this.removeFromJAR(iFile);
            }
        }
        return true;
    }

    private boolean isOnBuildFolder(IFile iFile) throws JavaModelException {
        IFolder iFolder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        return iFolder.getLocation().isPrefixOf(iFile.getLocation());
    }

    private boolean isOnBuildProperties(IResource iResource, boolean bl) throws CoreException {
        IPath iPath;
        MTJRuntimeList mTJRuntimeList = this.suiteProject.getRuntimeList();
        MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
        boolean bl2 = false;
        if (mTJRuntime != null && !(iPath = this.getOutputFolderRelativePath(iResource)).isEmpty() && !(iPath = this.findResourceOriginalPath(iPath, bl)).isEmpty()) {
            bl2 = this.isResourceFileOnBuildProperties(mTJRuntime, iPath);
        }
        return bl2;
    }

    private IPath findResourceOriginalPath(IPath iPath, boolean bl) throws CoreException {
        String string;
        Object object;
        IPath iPath2;
        Path path = Path.EMPTY;
        IResource[] iResourceArray = Utils.getSourceFolders(this.suiteProject.getJavaProject());
        if (bl) {
            iPath2 = this.getOutterClassName(iPath);
            IJavaProject iJavaProject = this.suiteProject.getJavaProject();
            IJavaElement iJavaElement = iJavaProject.findElement(iPath2);
            if (iJavaElement != null) {
                object = this.getPackageName(iJavaElement);
                string = iJavaElement.getElementName();
                iPath = new Path((String)object).append(string);
            }
        }
        object = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            iPath2 = object[n2];
            if (iPath2.getType() == 2 && (string = ((IFolder)iPath2).findMember(iPath)) != null) {
                path = string.getFullPath();
            }
            ++n2;
        }
        return path;
    }

    private boolean isResourceFileOnBuildProperties(MTJRuntime mTJRuntime, IPath iPath) throws CoreException {
        IResource[] iResourceArray;
        boolean bl = false;
        IResource[] iResourceArray2 = iResourceArray = this.properties.getIncludes(mTJRuntime);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            IPath iPath2 = iResource.getFullPath();
            if (!iPath2.equals((Object)iPath)) {
                if (iPath2.isPrefixOf(iPath)) {
                    IResource[] iResourceArray3;
                    bl = true;
                    IResource[] iResourceArray4 = iResourceArray3 = this.properties.getExcludes(mTJRuntime);
                    int n3 = iResourceArray3.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource iResource2 = iResourceArray4[n4];
                        IPath iPath3 = iResource2.getFullPath();
                        if (iPath2.isPrefixOf(iPath3) && iPath3.isPrefixOf(iPath) || iPath.equals((Object)iPath3)) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) break;
            ++n2;
        }
        return bl;
    }

    private IPath getOutterClassName(IPath iPath) {
        IPath iPath2 = iPath;
        String string = iPath.lastSegment();
        if (string != null && string.contains("$")) {
            string = string.substring(0, string.indexOf("$"));
            iPath2 = iPath.removeLastSegments(1).append(NLS.bind((String)"{0}.class", (Object)string));
        }
        return iPath2;
    }

    private String getPackageName(IJavaElement iJavaElement) {
        String string = "";
        IJavaElement iJavaElement2 = iJavaElement.getParent();
        if (iJavaElement2 instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement2;
            string = iPackageFragment.getElementName().replace(".", "/");
        }
        return string;
    }

    private IPath getOutputFolderRelativePath(IResource iResource) throws CoreException {
        IFolder iFolder = PackageBuilder.getOutputFolder(this.suiteProject.getJavaProject());
        if (iFolder.getFullPath().isPrefixOf(iResource.getFullPath())) {
            IPath iPath = iResource.getFullPath().removeFirstSegments(iFolder.getFullPath().segmentCount());
            return new Path(iPath.toString());
        }
        return new Path("");
    }

    private IFile getPreVerifiedClassFile(IFile iFile) throws CoreException {
        IFolder iFolder = this.suiteProject.getVerifiedClassesOutputFolder((IProgressMonitor)new NullProgressMonitor());
        IFile iFile2 = iFolder.getFile(this.getOutputFolderRelativePath((IResource)iFile));
        if (iFile2.exists()) {
            return iFile2;
        }
        return null;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        if (iResource instanceof IFile) {
            IFile iFile = (IFile)iResource;
            switch (iResourceDelta.getKind()) {
                case 1: 
                case 4: {
                    this.visit((IResource)iFile);
                    break;
                }
                case 2: {
                    this.removeFromJAR(iFile);
                }
            }
        }
        return true;
    }

    private void removeFromJAR(IFile iFile) throws CoreException {
        de.schlichtherle.io.File file;
        IPath iPath = null;
        iPath = iFile.getName().endsWith(".class") ? PackageBuilder.getClassZipPath(this.suiteProject, iFile) : PackageBuilder.getResourceZipPath(this.suiteProject, iFile);
        if (iPath != null && (file = new de.schlichtherle.io.File((File)this.jar, iPath.toString())).exists()) {
            file.delete();
        }
    }

    public List<IFile> getResourcesToPackage() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(this.resources);
        return arrayList;
    }

    public List<IFile> getClassesToPackage() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(this.classes);
        return arrayList;
    }
}

