/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.l10n;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.MTJBuildState;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJIncrementalProjectBuilder;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class L10nBuilder
extends MTJIncrementalProjectBuilder {
    protected IProject[] doBuild(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        try {
            IResourceDelta iResourceDelta = this.getDelta(iProject);
            if (iResourceDelta != null) {
                if (this.hasLocalizationDataChanged(iProject, iResourceDelta)) {
                    this.doBuild(iProject, iProgressMonitor);
                }
            } else {
                this.doBuild(iProject, iProgressMonitor);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MTJStatusHandler.throwCoreException(4, 0, fileNotFoundException);
        }
        return null;
    }

    protected void doClean(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragmentRoot[] iPackageFragmentRootArray;
        iProgressMonitor.subTask(Messages.L10nBuilder_clean_CleaningOldProperties);
        IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
        IPackageFragmentRoot[] iPackageFragmentRootArray2 = iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n2 = iPackageFragmentRootArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray2[n3];
            if (iPackageFragmentRoot.getKind() == 1) {
                iPackageFragmentRoot.getCorrespondingResource().accept(new IResourceVisitor(){

                    public boolean visit(IResource iResource) throws CoreException {
                        String string = iResource.getName();
                        if (string.startsWith("messages") && string.endsWith(".properties")) {
                            iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        return true;
                    }
                });
            }
            ++n3;
        }
    }

    protected String getBuilderId() {
        return "org.eclipse.mtj.core.l10nBuilder";
    }

    protected MTJBuildState getEnterState() {
        return MTJBuildState.PRE_LOCALIZATION;
    }

    protected MTJBuildState getExitState() {
        return MTJBuildState.POST_LOCALIZATION;
    }

    private boolean hasLocalizationDataChanged(IProject iProject, IResourceDelta iResourceDelta) throws FileNotFoundException {
        boolean bl = false;
        IFile iFile = iProject.getFile("Localization Data");
        if (iFile.exists()) {
            IResourceDelta iResourceDelta2 = iResourceDelta.findMember(iFile.getProjectRelativePath());
            if (iResourceDelta2 != null) {
                switch (iResourceDelta2.getKind()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        bl = true;
                    }
                }
            }
        } else {
            throw new FileNotFoundException(Messages.L10nBuilder_LocalizationDataDoesNotExist);
        }
        return bl;
    }

    private void doBuild(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            L10nModel l10nModel = L10nApi.loadL10nModel(iProject);
            if (l10nModel.isValid()) {
                iProgressMonitor.subTask(Messages.L10nBuilder_BuildingLocalizationData);
                L10nLocales l10nLocales = l10nModel.getLocales();
                IFolder iFolder = iProject.getFolder(l10nLocales.getDestination());
                if (!iFolder.exists()) {
                    iFolder.create(true, true, iProgressMonitor);
                }
                iProgressMonitor.subTask(Messages.L10nBuilder_generatingProperties);
                this.createProperties(iProject, l10nLocales, iFolder, iProgressMonitor);
                IJavaProject iJavaProject = JavaCore.create((IProject)this.getProject());
                IPackageFragment[] iPackageFragmentArray = iJavaProject.getPackageFragments();
                int n = 0;
                while (n < iPackageFragmentArray.length) {
                    if (iPackageFragmentArray[n].getElementName().equals(l10nLocales.getPackage())) {
                        iProgressMonitor.subTask(Messages.L10nBuilder_updatingConstants);
                        String string = L10nApi.buildL10nConstantsClass(iProject, iPackageFragmentArray[n]);
                        iPackageFragmentArray[n].createCompilationUnit("L10nConstants.java", string, true, iProgressMonitor);
                        break;
                    }
                    ++n;
                }
                IFolder iFolder2 = iProject.getFolder((IPath)new Path(l10nLocales.getDestination()));
                if (iFolder2.exists()) {
                    iFolder2.refreshLocal(1, iProgressMonitor);
                }
            } else {
                MTJLogger.log(4, Messages.L10nBuilder_InvalidModel);
            }
        }
        catch (Exception exception) {
            MTJStatusHandler.throwCoreException(4, 0, exception);
        }
    }

    private void createProperties(IProject iProject, L10nLocales l10nLocales, IFolder iFolder, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor.subTask(Messages.L10nBuilder_ProcessingLocalizationData);
        List<IDocumentElementNode> list = l10nLocales.getChildren();
        for (IDocumentElementNode iDocumentElementNode : list) {
            L10nLocale l10nLocale = (L10nLocale)iDocumentElementNode;
            IFile iFile = this.writePropertyFile(l10nLocale, iFolder, iProgressMonitor);
            IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
            MTJBuildProperties mTJBuildProperties = MTJBuildProperties.getBuildProperties(iMTJProject);
            for (MTJRuntime mTJRuntime : iMTJProject.getRuntimeList()) {
                mTJBuildProperties.includeResource((IResource)iFile, mTJRuntime);
            }
        }
    }

    private IFile writePropertyFile(L10nLocale l10nLocale, IFolder iFolder, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor.subTask(NLS.bind((String)"Writing Localization Data for locale {0}", (Object)l10nLocale.getLocaleName()));
        if (!iFolder.exists()) {
            throw new FileNotFoundException(Messages.L10nBuilder_PackageFolderNotFound);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        IFile iFile = null;
        String string = null;
        string = l10nLocale.getLocaleName() != null ? NLS.bind((String)"messages_{0}.properties", (Object)l10nLocale.getLocaleName()) : "messages.properties";
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                IDocumentElementNode[] iDocumentElementNodeArray = l10nLocale.getChildNodes();
                int n = 0;
                while (n < iDocumentElementNodeArray.length) {
                    L10nEntry l10nEntry = (L10nEntry)iDocumentElementNodeArray[n];
                    stringBuffer.append(l10nEntry.getKey().toUpperCase());
                    stringBuffer.append("=");
                    stringBuffer.append(l10nEntry.getValue());
                    stringBuffer.append("\n");
                    ++n;
                }
                byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
                iFile = iFolder.getFile(string);
                if (iFile.exists()) {
                    iFile.setContents((InputStream)byteArrayInputStream, 1, iProgressMonitor);
                } else {
                    iFile.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
                }
            }
            catch (Exception exception) {
                throw new IOException(NLS.bind((String)Messages.L10nBuilder_ErrorWritingProperty, (Object)l10nLocale.getLocaleName()));
            }
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        return iFile;
    }
}

