/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.refactoring.BuildPropertiesChange;
import org.eclipse.osgi.util.NLS;

public class BuildPropertiesRenameParticipant
extends RenameParticipant {
    private IType type;
    private IFile file;

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker(ResourceChangeChecker.class);
        if (resourceChangeChecker != null && this.file.exists()) {
            IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = resourceChangeChecker.getDeltaFactory();
            iResourceChangeDescriptionFactory.change(this.file);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = null;
        IResource iResource = this.type.getResource();
        if (iResource != null) {
            IPath iPath = iResource.getProjectRelativePath();
            IPath iPath2 = iPath.removeLastSegments(1);
            iPath2 = iPath2.append(NLS.bind((String)"{0}.java", (Object)this.getArguments().getNewName()));
            CompositeChange compositeChange2 = new CompositeChange(Messages.BuildPropertiesRenameParticipant_buildPropertiesChangeMessage);
            BuildPropertiesChange buildPropertiesChange = new BuildPropertiesChange(this.file, iPath.toString(), iPath2.toString());
            if (buildPropertiesChange.hasPropertiesChanges()) {
                compositeChange2.add((Change)buildPropertiesChange);
                compositeChange = compositeChange2;
            }
        }
        return compositeChange;
    }

    protected boolean initialize(Object object) {
        boolean bl = false;
        if (object instanceof IType) {
            this.type = (IType)object;
            IProject iProject = this.type.getJavaProject().getProject();
            this.file = iProject.getFile("build.properties");
            bl = true;
        }
        return bl;
    }

    public String getName() {
        return Messages.BuildPropertiesRenameParticipant_buildPropertiesParticipantName;
    }
}

