/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.templates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mtj.internal.templates.Messages;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayTemplateWizardPage
extends AbstractTemplateWizardPage {
    private static final String NEW_TEXT_BOX = "new TextBox(\"Text [Screen {0}]\", \"\", 100, TextField.ANY)";
    private static final String NEW_LIST = "new List(\"List [Screen {0}]\", List.IMPLICIT)";
    private static final String NEW_FORM = "new Form(\"Form [Screen {0}]\")";
    private static final String IMPORT_TEXT = "import javax.microedition.lcdui.TextBox;\n";
    private static final String IMPORT_LIST = "import javax.microedition.lcdui.List;\n";
    private static final String IMPORT_FORM = "import javax.microedition.lcdui.Form;\n";
    private static final String IMPORT_TEXT_FIELD = "import javax.microedition.lcdui.TextField;\n";
    private Button textBtn1;
    private Button listBtn1;
    private Button formBtn1;
    private Button textBtn2;
    private Button listBtn2;
    private Button formBtn2;
    private Button listBtn3;
    private Button formBtn3;
    private Button textBtn3;

    public void createControl(Composite composite) {
        int n = 1;
        while (n <= 3) {
            this.createScreenGroup(n, composite);
            ++n;
        }
    }

    private void createScreenGroup(int n, Composite composite) {
        GridData gridData = null;
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite, 0);
        group.setText(NLS.bind((String)Messages.DisplayTemplateProvider_0, (Object)n));
        gridData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(1, false));
        Button button = new Button((Composite)group, 16);
        button.setText("javax.microedition.lcdui.TextBox");
        gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.setSelection(true);
        Button button2 = new Button((Composite)group, 16);
        button2.setText("javax.microedition.lcdui.List");
        gridData = new GridData(768);
        button2.setLayoutData((Object)gridData);
        Button button3 = new Button((Composite)group, 16);
        button3.setText("javax.microedition.lcdui.Form");
        gridData = new GridData(768);
        button3.setLayoutData((Object)gridData);
        switch (n) {
            case 1: {
                this.textBtn1 = button;
                this.listBtn1 = button2;
                this.formBtn1 = button3;
                break;
            }
            case 2: {
                this.textBtn2 = button;
                this.listBtn2 = button2;
                this.formBtn2 = button3;
                break;
            }
            case 3: {
                this.textBtn3 = button;
                this.listBtn3 = button2;
                this.formBtn3 = button3;
            }
        }
    }

    public Map<String, String> getDictionary() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$screen1$", this.getScreen1());
        hashMap.put("$screen2$", this.getScreen2());
        hashMap.put("$screen3$", this.getScreen3());
        hashMap.put("$import$", this.getImports());
        return hashMap;
    }

    private String getScreen3() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.textBtn3.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)3));
        } else if (this.listBtn3.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_LIST, (Object)3));
        } else if (this.formBtn3.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_FORM, (Object)3));
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private String getScreen2() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.textBtn2.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)2));
        } else if (this.listBtn2.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_LIST, (Object)2));
        } else if (this.formBtn2.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_FORM, (Object)2));
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private String getScreen1() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.textBtn1.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)1));
        } else if (this.listBtn1.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_LIST, (Object)1));
        } else if (this.formBtn1.getSelection()) {
            stringBuffer.append(NLS.bind((String)NEW_FORM, (Object)1));
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private String getImports() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.formBtn1.getSelection() || this.formBtn2.getSelection() || this.formBtn3.getSelection()) {
            stringBuffer.append(IMPORT_FORM);
        }
        if (this.listBtn1.getSelection() || this.listBtn2.getSelection() || this.listBtn3.getSelection()) {
            stringBuffer.append(IMPORT_LIST);
        }
        if (this.textBtn1.getSelection() || this.textBtn2.getSelection() || this.textBtn3.getSelection()) {
            stringBuffer.append(IMPORT_TEXT);
            stringBuffer.append(IMPORT_TEXT_FIELD);
        }
        return stringBuffer.toString();
    }

    public boolean isPageComplete() {
        return true;
    }
}

