/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.examples.toolkits.motorola;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceImporter;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.examples.toolkits.Activator;
import org.eclipse.mtj.examples.toolkits.motorola.MotorolaDevice;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotorolaDeviceImporter
implements IDeviceImporter {
    private static final String DEBUG_SERVER_SUFFIX = "_debug.server";
    private static final String DEVICES_SUFFIX = "_devices";
    private static final String EXECUTABLE_SUFFIX = "_executable";
    private static final String LAUNCH_COMMAND_SUFFIX = "_launch.command";
    private static final String PROPS_EMULATORS_LIST = "emulators.list";
    private static final String PROPS_FILE = "moto_emulators.properties";
    private Map<String, EmulatorData> emulatorDataMap;

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        List<IDevice> list = null;
        File file2 = new File(file, "resources");
        if (file2.exists()) {
            list = this.getResourcesDevices(file2, iProgressMonitor);
        }
        return list;
    }

    private IDevice createDevice(File file, Properties properties, String string) {
        IDevice iDevice = null;
        EmulatorData emulatorData = this.getEmulatorData(string);
        if (emulatorData != null) {
            iDevice = this.createDevice(file, properties, string, emulatorData);
        }
        return iDevice;
    }

    private IDevice createDevice(File file, Properties properties, String string, EmulatorData emulatorData) {
        File file2 = file.getParentFile().getParentFile();
        File file3 = file2.getParentFile();
        File file4 = file3.getParentFile();
        MotorolaDevice motorolaDevice = new MotorolaDevice();
        try {
            motorolaDevice.setBundle(Activator.getDefault().getBundle().getSymbolicName());
            motorolaDevice.setClasspath(this.getClasspath(file3));
            motorolaDevice.setDebugServer(emulatorData.debugServer);
            motorolaDevice.setDescription(string);
            motorolaDevice.setDeviceProperties(properties);
            motorolaDevice.setExecutable(new File(file2, emulatorData.executable));
            motorolaDevice.setGroupName(file4.getName());
            motorolaDevice.setName(string);
            motorolaDevice.setPreverifier(this.getPreverifier(file2, file4));
            motorolaDevice.setPropertiesFile(file);
            motorolaDevice.setProtectionDomains(new String[0]);
            motorolaDevice.setLaunchCommandTemplate(emulatorData.launchCommandTemplate);
            ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)motorolaDevice);
            ISymbolSet iSymbolSet2 = MTJCore.getSymbolSetFactory().createSymbolSetFromProperties(properties);
            iSymbolSet.add(iSymbolSet2.getSymbols());
            iSymbolSet.setName(motorolaDevice.getName());
            motorolaDevice.setSymbolSet(iSymbolSet);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)2, (String)("Error importing device " + string), (Throwable)coreException);
            motorolaDevice = null;
        }
        return motorolaDevice;
    }

    private File findPreverifyExecutable(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.equals("preverify.exe") || string.equals("preverify");
            }
        });
        File file2 = null;
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].isDirectory()) {
                file2 = fileArray[n];
                break;
            }
            file2 = this.findPreverifyExecutable(fileArray[n]);
            ++n;
        }
        return file2;
    }

    private IDeviceClasspath getClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        File file2 = new File(file, "lib");
        File[] fileArray = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isFile() && (string.endsWith(".zip") || string.endsWith(".jar"));
            }
        });
        ILibraryImporter iLibraryImporter = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        int n = 0;
        while (n < fileArray.length) {
            IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)iLibraryImporter.createLibraryFor(fileArray[n]);
            iDeviceClasspath.addEntry((ILibrary)iMIDPLibrary);
            ++n;
        }
        return iDeviceClasspath;
    }

    private EmulatorData getEmulatorData(String string) {
        return this.getEmulatorDataMap().get(string);
    }

    private Map<String, EmulatorData> getEmulatorDataMap() {
        if (this.emulatorDataMap == null) {
            this.emulatorDataMap = this.readEmulatorDataMap();
        }
        return this.emulatorDataMap;
    }

    private IPreverifier getPreverifier(File file, File file2) throws CoreException {
        File file3 = this.findPreverifyExecutable(file);
        if (file3 == null) {
            file3 = this.findPreverifyExecutable(file2);
        }
        return MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file3);
    }

    private Properties getProperties(File file) {
        Properties properties;
        block14: {
            properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
                catch (IOException iOException) {
                    MTJLogger.log((int)2, (String)("Error reading properties file " + file), (Throwable)iOException);
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private List<IDevice> getResourcesDevices(File file, IProgressMonitor iProgressMonitor) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".props");
            }
        });
        ArrayList<IDevice> arrayList = new ArrayList<IDevice>();
        int n = 0;
        while (n < fileArray.length) {
            IDevice iDevice;
            File file2 = fileArray[n];
            Properties properties = this.getProperties(file2);
            String string = properties.getProperty("devicename");
            if (string != null && (iDevice = this.createDevice(file2, properties, string)) != null) {
                arrayList.add(iDevice);
            }
            ++n;
        }
        return arrayList;
    }

    private void parseEmulatorDataProperties(Map<String, EmulatorData> map, Properties properties, String string) {
        String string2 = properties.getProperty(String.valueOf(string) + DEVICES_SUFFIX, "");
        String string3 = properties.getProperty(String.valueOf(string) + DEBUG_SERVER_SUFFIX, "");
        EmulatorData emulatorData = new EmulatorData();
        emulatorData.executable = properties.getProperty(String.valueOf(string) + EXECUTABLE_SUFFIX, "");
        emulatorData.launchCommandTemplate = properties.getProperty(String.valueOf(string) + LAUNCH_COMMAND_SUFFIX, "");
        emulatorData.devices = string2.length() > 0 ? string2.split(",") : new String[0];
        emulatorData.debugServer = string3.equalsIgnoreCase("true");
        int n = 0;
        while (n < emulatorData.devices.length) {
            String string4 = emulatorData.devices[n];
            map.put(string4, emulatorData);
            ++n;
        }
    }

    private Map<String, EmulatorData> parseEmulatorDataProperties(Properties properties) {
        HashMap<String, EmulatorData> hashMap = new HashMap<String, EmulatorData>();
        String string = properties.getProperty(PROPS_EMULATORS_LIST, "");
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            this.parseEmulatorDataProperties(hashMap, properties, stringArray[n]);
            ++n;
        }
        return hashMap;
    }

    private Map<String, EmulatorData> readEmulatorDataMap() {
        Properties properties;
        block15: {
            properties = new Properties();
            InputStream inputStream = null;
            try {
                try {
                    Bundle bundle = Activator.getDefault().getBundle();
                    URL uRL = bundle.getEntry(PROPS_FILE);
                    inputStream = uRL.openStream();
                    if (inputStream != null) {
                        properties.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    MTJLogger.log((int)4, (String)"Error loading Motorola emulator properties", (Throwable)iOException);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.parseEmulatorDataProperties(properties);
    }

    private class EmulatorData {
        public boolean debugServer;
        public String[] devices;
        public String executable;
        public String launchCommandTemplate;

        private EmulatorData() {
        }
    }
}

