/**
 * Copyright (c) 2008,2009 Motorola.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     David Marques (Motorola) - Initial Version
 */
package org.eclipse.mtj.core.project.midp;

/**
 * ProjectConvertionException Class wraps exceptions during a project conversion
 * process.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * @since 1.0
 */
public class ProjectConvertionException extends Exception {

    /**
     * Default serial version UID
     */
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new ProjectConvertionException with the specified detail
     * message and cause.
     * <p>
     * Note that the detail message associated with <code>cause</code> is
     * <i>not</i> automatically incorporated in this exception's detail message.
     * 
     * @param message the detail message (which is saved for later retrieval by
     *            the {@link #getMessage()} method).
     * @param throwable the cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.) Creates a ProjectConvertionException instance.
     * 
     * @param message error message.
     * @param throwable wrapped throwable.
     */
    public ProjectConvertionException(String message, Throwable throwable) {
        super(message, throwable);
    }

    /**
     * Constructs a new ProjectConvertionException with the specified detail
     * message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     * 
     * @param message the detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     */
    public ProjectConvertionException(String message) {
        super(message);
    }
}
