/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntBooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntDoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableIntDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.factory.primitive.IntBooleanMaps;
import org.eclipse.collections.impl.factory.primitive.IntDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class SizeConfig
implements IPersistable {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING = ".percentageSizing";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES = ".percentageSizingIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZES = ".percentageSizes";
    public static final String PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE = ".distributeRemainingSpace";
    public static final String PERSISTENCE_KEY_DEFAULT_MIN_SIZE = ".defaultMinSize";
    public static final String PERSISTENCE_KEY_MIN_SIZES = ".minSizes";
    protected int defaultSize;
    protected final MutableIntIntMap defaultSizeMap = IntIntMaps.mutable.empty();
    protected final MutableIntIntMap sizeMap = IntIntMaps.mutable.empty();
    protected final MutableIntBooleanMap resizablesMap = IntBooleanMaps.mutable.empty();
    protected boolean resizableByDefault = true;
    protected final MutableIntDoubleMap percentageSizeMap = IntDoubleMaps.mutable.empty();
    protected final MutableIntBooleanMap percentageSizingMap = IntBooleanMaps.mutable.empty();
    protected boolean percentageSizing = false;
    protected int availableSpace = -1;
    protected final MutableIntIntMap realSizeMap = IntIntMaps.mutable.empty();
    protected final MutableIntIntMap aggregatedSizeCacheMap = IntIntMaps.mutable.empty();
    protected boolean isAggregatedSizeCacheValid = true;
    protected IDpiConverter dpiConverter;
    private boolean distributeRemainingSpace = true;
    private int defaultMinSize = 0;
    private final MutableIntIntMap minSizeMap = IntIntMaps.mutable.empty();
    private boolean fixPercentageValuesOnResize = true;

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        StringBuilder builder = new StringBuilder();
        if (!this.defaultSizeMap.isEmpty()) {
            for (IntIntPair pair : this.defaultSizeMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, builder.toString());
        }
        if (!this.sizeMap.isEmpty()) {
            builder = new StringBuilder();
            for (IntIntPair pair : this.sizeMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, builder.toString());
        }
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        if (!this.resizablesMap.isEmpty()) {
            builder = new StringBuilder();
            for (IntIntPair pair : this.resizablesMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, builder.toString());
        }
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING, String.valueOf(this.percentageSizing));
        if (!this.percentageSizeMap.isEmpty()) {
            builder = new StringBuilder();
            for (IntIntPair pair : this.percentageSizeMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZES, builder.toString());
        }
        if (!this.percentageSizingMap.isEmpty()) {
            builder = new StringBuilder();
            for (IntIntPair pair : this.percentageSizingMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, builder.toString());
        }
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE, String.valueOf(this.distributeRemainingSpace));
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_MIN_SIZE, String.valueOf(this.defaultMinSize));
        if (!this.minSizeMap.isEmpty()) {
            builder = new StringBuilder();
            for (IntIntPair pair : this.minSizeMap.keyValuesView().toSortedList()) {
                builder.append(pair.getOne()).append(":").append(pair.getTwo()).append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_MIN_SIZES, builder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String persistedDefaultMinSize;
        String persistedDistributeRemainingSpace;
        String persistedPercentageSizing;
        String persistedResizableDefault;
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.percentageSizeMap.clear();
        this.percentageSizingMap.clear();
        this.resizablesMap.clear();
        this.aggregatedSizeCacheMap.clear();
        this.minSizeMap.clear();
        this.resizableByDefault = true;
        this.percentageSizing = false;
        this.distributeRemainingSpace = false;
        this.isAggregatedSizeCacheValid = false;
        this.defaultMinSize = 0;
        String persistedDefaultSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (persistedDefaultSize != null && persistedDefaultSize.length() > 0) {
            this.defaultSize = Integer.parseInt(persistedDefaultSize);
        }
        if ((persistedResizableDefault = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)) != null && persistedResizableDefault.length() > 0) {
            this.resizableByDefault = Boolean.parseBoolean(persistedResizableDefault);
        }
        if ((persistedPercentageSizing = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING)) != null && persistedPercentageSizing.length() > 0) {
            this.percentageSizing = Boolean.parseBoolean(persistedPercentageSizing);
        }
        if ((persistedDistributeRemainingSpace = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DISTRIBUTE_REMAINING_SPACE)) != null && persistedDistributeRemainingSpace.length() > 0) {
            this.distributeRemainingSpace = Boolean.parseBoolean(persistedDistributeRemainingSpace);
        }
        if ((persistedDefaultMinSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_MIN_SIZE)) != null && persistedDefaultMinSize.length() > 0) {
            this.defaultMinSize = Integer.parseInt(persistedDefaultMinSize);
        }
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
        this.loadDoubleMap(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZES, properties, this.percentageSizeMap);
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, properties, this.percentageSizingMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_MIN_SIZES, properties, this.minSizeMap);
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    private void loadIntegerMap(String key, Properties properties, MutableIntIntMap map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.parseInt(token.substring(0, separatorIndex)), Integer.parseInt(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadBooleanMap(String key, Properties properties, MutableIntBooleanMap map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.parseInt(token.substring(0, separatorIndex)), Boolean.parseBoolean(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadDoubleMap(String key, Properties properties, MutableIntDoubleMap map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.parseInt(token.substring(0, separatorIndex)), Double.parseDouble(token.substring(separatorIndex + 1)));
            }
        }
    }

    public void setDefaultSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSize = size;
        this.isAggregatedSizeCacheValid = false;
    }

    public int getDefaultSize() {
        return this.upScale(this.defaultSize);
    }

    public void setDefaultSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSizeMap.put(position, size);
        this.isAggregatedSizeCacheValid = false;
    }

    private int getDefaultSize(int position) {
        int size = this.defaultSizeMap.getIfAbsent(position, -1);
        if (size != -1) {
            return size;
        }
        return this.defaultSize;
    }

    public int getAggregateSize(int position) {
        if (position < 0) {
            return -1;
        }
        if (position == 0) {
            return 0;
        }
        if (this.isAllPositionsSameSize() && !this.isPercentageSizing()) {
            return position * this.upScale(this.defaultSize);
        }
        if (!this.isAggregatedSizeCacheValid) {
            this.aggregatedSizeCacheMap.clear();
            this.isAggregatedSizeCacheValid = true;
        }
        if (!this.aggregatedSizeCacheMap.containsKey(position)) {
            int aggregatedSize = this.calculateAggregatedSize(position);
            this.aggregatedSizeCacheMap.put(position, aggregatedSize);
        }
        return this.aggregatedSizeCacheMap.get(position);
    }

    public int getSize(int position) {
        int size = -1;
        if (this.isPercentageSizing()) {
            int value = this.realSizeMap.getIfAbsent(position, -1);
            if (value != -1) {
                return value;
            }
        } else if (this.sizeMap.containsKey(position)) {
            size = this.sizeMap.get(position);
        }
        if (size != -1) {
            return this.upScale(size);
        }
        return this.upScale(this.getDefaultSize(position));
    }

    public int getMinSize(int position) {
        if (this.minSizeMap.containsKey(position)) {
            return this.upScale(this.minSizeMap.get(position));
        }
        return this.upScale(this.getDefaultMinSize());
    }

    public void setMinSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.minSizeMap.put(position, size);
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public int getDefaultMinSize() {
        return this.defaultMinSize;
    }

    public void setDefaultMinSize(int defaultMinSize) {
        if (defaultMinSize < 0) {
            throw new IllegalArgumentException("defaultMinSize < 0");
        }
        this.defaultMinSize = defaultMinSize;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public boolean isMinSizeConfigured() {
        return this.defaultMinSize > 0 || !this.minSizeMap.isEmpty();
    }

    public boolean isMinSizeConfigured(int position) {
        return this.minSizeMap.containsKey(position) && this.minSizeMap.get(position) > 0 || this.defaultMinSize > 0;
    }

    public void setSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.isPositionResizable(position)) {
            if (!this.isPercentageSizing(position)) {
                int oldValue = this.sizeMap.getIfAbsent(position, -1);
                int diff = oldValue != -1 ? size - oldValue : size - this.getDefaultSize(position);
                this.sizeMap.put(position, size);
                if (this.isPercentageSizing() && this.fixPercentageValuesOnResize && this.availableSpace > 0) {
                    int percentageSpace = this.calculateAvailableSpace(this.availableSpace);
                    this.fixPercentageValues(percentageSpace);
                    double diffPercentage = (double)this.upScale(diff) * 100.0 / (double)percentageSpace;
                    this.updateAdjacent(position, diffPercentage, percentageSpace);
                }
            } else if (this.availableSpace > 0) {
                boolean minSizeUpdate;
                int percentageSpace = this.calculateAvailableSpace(this.availableSpace);
                double percentage = (double)size * 100.0 / (double)percentageSpace;
                boolean bl = minSizeUpdate = this.isMinSizeConfigured(position) && size < this.getMinSize(position);
                if (this.fixPercentageValuesOnResize) {
                    this.fixPercentageValues(percentageSpace);
                }
                double oldValue = this.percentageSizeMap.getIfAbsent(position, -1.0);
                double diff = percentage;
                if (oldValue != -1.0 && !minSizeUpdate) {
                    diff -= oldValue;
                } else if (this.realSizeMap.containsKey(position)) {
                    double calculated = (double)this.realSizeMap.get(position) * 100.0 / (double)percentageSpace;
                    diff -= calculated;
                }
                if (minSizeUpdate) {
                    this.percentageSizeMap.forEachKeyValue((IntDoubleProcedure & Serializable)(key, value) -> {
                        double calculated;
                        if (key != position && this.isPercentageSizing(key) && (calculated = (double)this.realSizeMap.get(key) * 100.0 / (double)percentageSpace) < value) {
                            this.percentageSizeMap.put(key, calculated);
                        }
                    });
                    this.setMinSize(position, size);
                }
                this.percentageSizeMap.put(position, percentage);
                diff = this.updateAdjacent(position, diff, percentageSpace);
                if (diff != 0.0 && oldValue == -1.0) {
                    this.percentageSizeMap.remove(position);
                }
                if (percentage > 100.0) {
                    double adjusted = 100.0 - this.percentageSizeMap.select((IntDoublePredicate & Serializable)(key, value) -> key != position).sum();
                    this.percentageSizeMap.put(position, adjusted);
                }
            } else {
                this.percentageSizeMap.put(position, (double)size);
            }
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
            this.isAggregatedSizeCacheValid = false;
        }
    }

    private void fixPercentageValues(int percentageSpace) {
        this.realSizeMap.forEachKeyValue((IntIntProcedure & Serializable)(pos, value) -> {
            if (this.isPercentageSizing(pos)) {
                if (!this.percentageSizeMap.containsKey(pos)) {
                    double calculatedPercentage = (double)value * 100.0 / (double)percentageSpace;
                    this.percentageSizeMap.put(pos, calculatedPercentage);
                } else {
                    int calculated = this.calculatePercentageValue(this.percentageSizeMap.get(pos), percentageSpace);
                    if (this.isMinSizeConfigured(pos) && calculated < this.getMinSize(pos)) {
                        double minPercentageValue = (double)this.getMinSize(pos) * 100.0 / (double)percentageSpace;
                        this.percentageSizeMap.put(pos, minPercentageValue);
                    } else if (this.realSizeMap.containsKey(pos)) {
                        double distributedPercentageValue = (double)this.realSizeMap.get(pos) * 100.0 / (double)percentageSpace;
                        this.percentageSizeMap.put(pos, distributedPercentageValue);
                    }
                }
            }
        });
    }

    private double updateAdjacent(int originalPosition, double diff, int percentageSpace) {
        int nextPosition = originalPosition + 1;
        while (diff != 0.0 && this.realSizeMap.containsKey(nextPosition)) {
            if (this.isPositionResizable(nextPosition)) {
                diff = this.updateAdjacentPosition(nextPosition, diff, percentageSpace);
            }
            ++nextPosition;
        }
        int previousPosition = originalPosition - 1;
        while (diff != 0.0 && this.realSizeMap.containsKey(previousPosition)) {
            if (this.isPositionResizable(previousPosition)) {
                diff = this.updateAdjacentPosition(previousPosition, diff, percentageSpace);
            }
            --previousPosition;
        }
        return diff;
    }

    private double updateAdjacentPosition(int position, double diff, int percentageSpace) {
        boolean percentageConfigured = this.percentageSizeMap.containsKey(position);
        if (percentageConfigured || this.isPercentageSizing(position) && this.realSizeMap.containsKey(position)) {
            if (this.isPercentageSizing(position) && percentageConfigured) {
                double currentValue = this.percentageSizeMap.get(position);
                if (diff < currentValue) {
                    double newPercentageValue = currentValue - diff;
                    if (this.isMinSizeConfigured(position) && this.calculatePercentageValue(newPercentageValue, percentageSpace) < this.getMinSize(position)) {
                        double minPercentageValue = (double)this.getMinSize(position) * 100.0 / (double)percentageSpace;
                        double newDiff = diff - (currentValue - minPercentageValue);
                        this.percentageSizeMap.put(position, minPercentageValue);
                        return newDiff;
                    }
                    this.percentageSizeMap.put(position, newPercentageValue);
                    return 0.0;
                }
                diff = diff - currentValue + 1.0;
                this.percentageSizeMap.put(position, 1.0);
                return diff;
            }
            return 0.0;
        }
        return diff;
    }

    public void setPercentage(int position, int percentage) {
        this.setPercentage(position, (double)percentage);
    }

    public void setPercentage(int position, double percentage) {
        if (percentage < 0.0) {
            throw new IllegalArgumentException("percentage < 0");
        }
        if (this.isPositionResizable(position)) {
            this.percentageSizingMap.put(position, true);
            this.percentageSizeMap.put(position, percentage);
            this.realSizeMap.put(position, this.calculatePercentageValue(percentage, this.availableSpace));
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(int position) {
        return this.resizablesMap.getIfAbsent(position, this.resizableByDefault);
    }

    public void setPositionResizable(int position, boolean resizable) {
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0 && this.percentageSizeMap.size() == 0;
    }

    public boolean isPercentageSizing() {
        if (!this.percentageSizingMap.isEmpty() && this.percentageSizingMap.containsValue(true)) {
            return true;
        }
        return this.percentageSizing;
    }

    public void setPercentageSizing(boolean percentageSizing) {
        this.percentageSizing = percentageSizing;
        this.isAggregatedSizeCacheValid = false;
        if (!this.sizeMap.isEmpty()) {
            MutableIntIntMap transfer = this.sizeMap.select((IntIntPredicate & Serializable)(key, value) -> this.isPercentageSizing(key));
            transfer.forEachKeyValue((IntIntProcedure & Serializable)(key, value) -> {
                this.percentageSizeMap.put(key, (double)value);
                this.sizeMap.remove(key);
            });
        }
    }

    public boolean isPercentageSizing(int position) {
        return this.percentageSizingMap.getIfAbsent(position, this.percentageSizing);
    }

    public void setPercentageSizing(int position, boolean percentageSizing) {
        this.percentageSizingMap.put(position, percentageSizing);
        this.isAggregatedSizeCacheValid = false;
    }

    public void calculatePercentages(int space, int positionCount) {
        if (space > -1 && this.isPercentageSizing()) {
            double remaining;
            this.isAggregatedSizeCacheValid = false;
            this.availableSpace = space;
            int percentageSpace = this.calculateAvailableSpace(space);
            double sum = 0.0;
            int real = 0;
            int realSum = 0;
            int fixedSum = 0;
            int minSizeIncrease = 0;
            MutableIntList noInfoPositions = IntLists.mutable.empty();
            MutableIntList fixedPercentagePositions = IntLists.mutable.empty();
            int positionValue = -1;
            double positionPercentageValue = -1.0;
            int i = 0;
            while (i < positionCount) {
                positionValue = this.sizeMap.getIfAbsent(i, -1);
                positionPercentageValue = this.percentageSizeMap.getIfAbsent(i, Double.valueOf("-1").doubleValue());
                if (positionPercentageValue == -1.0 && this.isPercentageSizing(i)) {
                    noInfoPositions.add(i);
                } else if (positionValue == -1 && !this.isPercentageSizing(i)) {
                    positionValue = this.getDefaultSize(i);
                }
                if (positionPercentageValue != -1.0 && this.isPercentageSizing(i)) {
                    int minSize;
                    real = this.calculatePercentageValue(positionPercentageValue, percentageSpace);
                    if (real < (minSize = this.getMinSize(i))) {
                        minSizeIncrease += this.upScale(minSize - real);
                        real = minSize;
                    } else {
                        sum += positionPercentageValue;
                    }
                    fixedPercentagePositions.add(i);
                    realSum += real;
                    this.realSizeMap.put(i, real);
                } else if (positionValue != -1) {
                    real = this.upScale(positionValue);
                    fixedSum += real;
                    realSum += real;
                    this.realSizeMap.put(i, real);
                }
                ++i;
            }
            int[] correction = this.correctPercentageValues(sum, positionCount);
            if (correction != null && correction.length > 0) {
                sum = correction[0];
                realSum = correction[1] + fixedSum;
            }
            if (!fixedPercentagePositions.isEmpty() && realSum > space) {
                int pos;
                MutableIntList noMinWidth = IntLists.mutable.empty();
                int sumMod = 0;
                MutableIntIterator it = fixedPercentagePositions.intIterator();
                while (it.hasNext()) {
                    pos = it.next();
                    if (this.realSizeMap.get(pos) == this.getMinSize(pos)) {
                        sumMod = (int)((double)sumMod + this.percentageSizeMap.get(pos));
                        it.remove();
                        continue;
                    }
                    noMinWidth.add(pos);
                }
                int[] nArray = noMinWidth.toArray();
                int n = nArray.length;
                pos = 0;
                while (pos < n) {
                    int pos2 = nArray[pos];
                    double percentage = this.percentageSizeMap.get(pos2);
                    double ratio = percentage / sum;
                    int dist = (int)Math.round((double)minSizeIncrease * ratio);
                    int newValue = this.realSizeMap.get(pos2) - dist;
                    newValue = newValue > 0 ? newValue : 0;
                    realSum -= this.realSizeMap.get(pos2) - newValue;
                    this.realSizeMap.put(pos2, newValue);
                    ++pos;
                }
                sum += (double)sumMod;
            }
            if (!noInfoPositions.isEmpty() && this.isMinSizeConfigured()) {
                double remaining2 = (double)space - (double)realSum;
                double remainingColSpace = remaining2 / (double)noInfoPositions.size();
                MutableIntIterator it = noInfoPositions.intIterator();
                while (it.hasNext()) {
                    int position = it.next();
                    int minSize = this.getMinSize(position);
                    if (!((double)minSize > remainingColSpace)) continue;
                    realSum += minSize;
                    this.realSizeMap.put(position, minSize);
                    it.remove();
                }
                if (realSum > space && !fixedPercentagePositions.isEmpty()) {
                    MutableIntList noMinWidth = IntLists.mutable.empty();
                    MutableIntIterator it2 = fixedPercentagePositions.intIterator();
                    while (it2.hasNext()) {
                        int pos = it2.next();
                        if (this.realSizeMap.get(pos) == this.getMinSize(pos)) continue;
                        noMinWidth.add(pos);
                    }
                    int exceed = realSum - space;
                    int[] nArray = noMinWidth.toArray();
                    int ratio = nArray.length;
                    int n = 0;
                    while (n < ratio) {
                        int pos = nArray[n];
                        double percentage = this.percentageSizeMap.get(pos);
                        double ratio2 = percentage / sum;
                        int dist = (int)Math.round((double)exceed * ratio2);
                        int newValue = this.realSizeMap.get(pos) - dist;
                        newValue = newValue > 0 ? newValue : 0;
                        realSum -= this.realSizeMap.get(pos) - newValue;
                        this.realSizeMap.put(pos, newValue);
                        ++n;
                    }
                }
            }
            if (!noInfoPositions.isEmpty()) {
                double remaining3 = (double)space - (double)realSum;
                double remainingColSpace = remaining3 / (double)noInfoPositions.size();
                int[] nArray = noInfoPositions.toArray();
                int n = nArray.length;
                int exceed = 0;
                while (exceed < n) {
                    int position = nArray[exceed];
                    sum += remainingColSpace / (double)space * 100.0;
                    int minSize = this.getMinSize(position);
                    this.realSizeMap.put(position, remainingColSpace < (double)minSize ? minSize : (int)remainingColSpace);
                    ++exceed;
                }
                sum = 100.0;
            }
            if (sum < 100.0 && !fixedPercentagePositions.isEmpty() && this.distributeRemainingSpace && (remaining = (double)space - (double)realSum) > 0.0) {
                double eligibleSum = fixedPercentagePositions.primitiveStream().mapToDouble(arg_0 -> ((MutableIntDoubleMap)this.percentageSizeMap).get(arg_0)).sum();
                int[] nArray = fixedPercentagePositions.toArray();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    if (this.getMinSize(pos) != this.realSizeMap.get(pos)) {
                        double percentage = this.percentageSizeMap.get(pos);
                        double ratio = percentage / eligibleSum;
                        int dist = (int)(remaining * ratio);
                        this.realSizeMap.put(pos, this.realSizeMap.get(pos) + dist);
                    }
                    ++n2;
                }
                sum = 100.0;
            }
            if (sum == 100.0) {
                int valueSum = (int)this.realSizeMap.values().sum();
                if (space > 0 && valueSum < space) {
                    int missingPixels = space - valueSum;
                    int pos = 0;
                    int i2 = missingPixels;
                    while (i2 > 0) {
                        if (!this.realSizeMap.containsKey(pos)) {
                            pos = 0;
                        }
                        int posValue = this.realSizeMap.getIfAbsent(pos, -1);
                        while (!(posValue == -1 || posValue != 0 && this.isPercentageSizing(pos) && this.getMinSize(pos) != posValue)) {
                            if (++pos > this.realSizeMap.keySet().max()) break;
                            posValue = this.realSizeMap.get(pos);
                        }
                        if (posValue != -1) {
                            this.realSizeMap.put(pos, posValue + 1);
                            ++pos;
                        }
                        --i2;
                    }
                }
            }
            if (realSum > this.availableSpace) {
                int extend = realSum - this.availableSpace;
                while (extend > 0) {
                    int remainingExtend = this.correctExtend(extend, fixedPercentagePositions);
                    extend = remainingExtend == extend ? 0 : remainingExtend;
                }
            }
        }
    }

    private int calculatePercentageValue(double percentage, int space) {
        double factor = percentage / 100.0;
        return (int)((double)space * factor);
    }

    protected int calculateAvailableSpace(int space) {
        if (!this.percentageSizingMap.isEmpty() && this.percentageSizing) {
            long toReduce = ((MutableIntList)this.percentageSizingMap.select((IntBooleanPredicate & Serializable)(key, value) -> !value && this.sizeMap.containsKey(key)).keySet().collectInt((IntToIntFunction & Serializable)key -> this.upScale(this.sizeMap.get(key)), (MutableIntCollection)IntLists.mutable.empty())).sum();
            space = (int)((long)space - toReduce);
        }
        return space;
    }

    protected int[] correctPercentageValues(double sum, int positionCount) {
        MutableIntIntMap toModify = IntIntMaps.mutable.empty();
        int fixedSum = 0;
        double modifySum = 0.0;
        int i = 0;
        while (i < positionCount) {
            int positionValue = this.sizeMap.getIfAbsent(i, -1);
            double positionPercentageValue = this.percentageSizeMap.getIfAbsent(i, Double.valueOf("-1").doubleValue());
            if (positionPercentageValue != -1.0 && this.isPercentageSizing(i) && (!this.isMinSizeConfigured(i) || this.isMinSizeConfigured(i) && this.realSizeMap.get(i) != this.getMinSize(i))) {
                toModify.put(i, this.realSizeMap.get(i));
                modifySum += positionPercentageValue;
            } else if (!this.isPercentageSizing(i) && positionValue != -1) {
                fixedSum += this.upScale(positionValue);
            }
            ++i;
        }
        if (sum > 100.0) {
            double excess = sum - 100.0;
            int excessPixel = (int)((double)(this.availableSpace - fixedSum) * excess / 100.0);
            double newPercentageSum = 0.0;
            int realSum = 0;
            for (IntIntPair mod : toModify.keyValuesView().toSortedList()) {
                double ratio = this.percentageSizeMap.get(mod.getOne()) / modifySum;
                int exc = (int)Math.ceil((double)excessPixel * ratio);
                int newValue = mod.getTwo() - exc;
                if (this.isMinSizeConfigured(mod.getOne()) && newValue < this.getMinSize(mod.getOne())) {
                    newValue = this.getMinSize(mod.getOne());
                }
                double newPercentage = ((double)newValue / (double)this.availableSpace - (double)fixedSum) * 100.0;
                newPercentageSum += newPercentage;
                realSum += newValue;
                this.realSizeMap.put(mod.getOne(), newValue);
            }
            if (newPercentageSum > 100.0 && excessPixel > 0) {
                return this.correctPercentageValues(newPercentageSum, positionCount);
            }
            return new int[]{100, realSum};
        }
        return new int[0];
    }

    private int calculateAggregatedSize(int position) {
        int size;
        int resizeAggregate = 0;
        int resizedColumns = 0;
        boolean pSizing = this.isPercentageSizing();
        MutableIntIntMap mapToUse = pSizing ? this.realSizeMap : this.sizeMap;
        int[] nArray = mapToUse.keySet().toSortedArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int resizedPosition = nArray[n2];
            if (resizedPosition >= position) break;
            ++resizedColumns;
            size = mapToUse.get(resizedPosition);
            resizeAggregate += pSizing ? size : this.upScale(size);
            ++n2;
        }
        nArray = this.defaultSizeMap.keySet().toSortedArray();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            int defaultPosition = nArray[n2];
            if (defaultPosition >= position) break;
            if (!mapToUse.containsKey(defaultPosition)) {
                ++resizedColumns;
                size = this.defaultSizeMap.get(defaultPosition);
                resizeAggregate += this.upScale(size);
            }
            ++n2;
        }
        int result = (position - resizedColumns) * this.upScale(this.defaultSize);
        return result += resizeAggregate;
    }

    private int correctExtend(int extend, MutableIntList fixedPercentagePositions) {
        int remainingExtend = extend;
        double eligibleSum = fixedPercentagePositions.primitiveStream().mapToDouble(arg_0 -> ((MutableIntDoubleMap)this.percentageSizeMap).get(arg_0)).sum();
        int[] nArray = fixedPercentagePositions.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int pos = nArray[n2];
            if (remainingExtend > 0 && this.getMinSize(pos) != this.realSizeMap.get(pos)) {
                double percentage = this.percentageSizeMap.get(pos);
                double ratio = percentage / eligibleSum;
                int dist = extend == 1 ? 1 : (int)((double)extend * ratio);
                int oldValue = this.realSizeMap.get(pos);
                int newValue = oldValue - dist;
                if (this.isMinSizeConfigured(pos) && newValue < this.getMinSize(pos)) {
                    newValue = this.getMinSize(pos);
                    dist = oldValue - newValue;
                } else if (newValue < 0) {
                    newValue = 0;
                    dist = oldValue;
                }
                this.realSizeMap.put(pos, newValue);
                remainingExtend -= dist;
            }
            ++n2;
        }
        return remainingExtend;
    }

    public void updatePercentageValues(int positionCount) {
        this.calculatePercentages(this.availableSpace, positionCount);
    }

    public int upScale(int value) {
        if (this.dpiConverter == null) {
            return value;
        }
        return this.dpiConverter.convertPixelToDpi(value);
    }

    public int downScale(int value) {
        if (this.dpiConverter == null) {
            return value;
        }
        return this.dpiConverter.convertDpiToPixel(value);
    }

    public void setDpiConverter(IDpiConverter dpiConverter) {
        this.dpiConverter = dpiConverter;
        this.isAggregatedSizeCacheValid = false;
    }

    public void reset() {
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.resizablesMap.clear();
        this.percentageSizeMap.clear();
        this.percentageSizingMap.clear();
        this.realSizeMap.clear();
        this.aggregatedSizeCacheMap.clear();
        this.minSizeMap.clear();
    }

    public void resetConfiguredSize(int position) {
        this.sizeMap.remove(position);
        this.percentageSizeMap.remove(position);
        this.isAggregatedSizeCacheValid = false;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public void resetConfiguredMinSize(int position) {
        this.minSizeMap.remove(position);
        this.isAggregatedSizeCacheValid = false;
        this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
    }

    public int getConfiguredSize(int position) {
        return this.sizeMap.getIfAbsent(position, -1);
    }

    public double getConfiguredPercentageSize(int position) {
        return this.percentageSizeMap.getIfAbsent(position, Double.valueOf("-1").doubleValue());
    }

    public int getConfiguredMinSize(int position) {
        return this.minSizeMap.getIfAbsent(position, -1);
    }

    public boolean isDistributeRemainingSpace() {
        return this.distributeRemainingSpace;
    }

    public void setDistributeRemainingSpace(boolean distributeRemaining) {
        this.distributeRemainingSpace = distributeRemaining;
    }

    public boolean isFixPercentageValuesOnResize() {
        return this.fixPercentageValuesOnResize;
    }

    public void setFixPercentageValuesOnResize(boolean enabled) {
        this.fixPercentageValuesOnResize = enabled;
    }
}

