/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.cdatetime;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CDateTimeCellEditor
extends AbstractCellEditor {
    private CDateTime dateTime;
    private final boolean moveSelectionOnEnter;
    private int style;
    private boolean provideCalendar = false;

    public CDateTimeCellEditor() {
        this(false);
    }

    public CDateTimeCellEditor(boolean moveSelectionOnEnter) {
        this(moveSelectionOnEnter, 0x900002);
    }

    public CDateTimeCellEditor(boolean moveSelectionOnEnter, int style) {
        this.moveSelectionOnEnter = moveSelectionOnEnter;
        this.style = style;
    }

    public Object getEditorValue() {
        if (this.dateTime.getSelection() != null) {
            return this.dateTime.getSelection();
        }
        return null;
    }

    public void setEditorValue(Object value) {
        if (value instanceof Calendar) {
            Calendar cal = (Calendar)value;
            this.dateTime.setSelection(cal.getTime());
        } else if (value instanceof Date) {
            this.dateTime.setSelection((Date)value);
        }
    }

    public Object getCanonicalValue() {
        if (this.provideCalendar) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)this.getEditorValue());
            return cal;
        }
        return this.getEditorValue();
    }

    public void setCanonicalValue(Object canonicalValue) {
        Date editorValue = null;
        if (canonicalValue instanceof Calendar) {
            editorValue = ((Calendar)canonicalValue).getTime();
        } else if (canonicalValue instanceof Date) {
            editorValue = (Date)canonicalValue;
        }
        if (editorValue != null) {
            this.setEditorValue(editorValue);
        }
    }

    public CDateTime getEditorControl() {
        return this.dateTime;
    }

    public CDateTime createEditorControl(final Composite parent) {
        CDateTime dateControl = new CDateTime(parent, this.style){

            protected Shell getContentShell() {
                Shell shell = super.getContentShell();
                shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellActivated(ShellEvent e) {
                        if (CDateTimeCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                            ((AbstractCellEditor.InlineFocusListener)((CDateTimeCellEditor)(this).CDateTimeCellEditor.this).focusListener).handleFocusChanges = false;
                        }
                    }

                    public void shellClosed(ShellEvent e) {
                        if (CDateTimeCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                            ((AbstractCellEditor.InlineFocusListener)((CDateTimeCellEditor)(this).CDateTimeCellEditor.this).focusListener).handleFocusChanges = true;
                        }
                    }
                });
                return shell;
            }

            protected void postClose(Shell popup) {
                if (CDateTimeCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((CDateTimeCellEditor)CDateTimeCellEditor.this).focusListener).handleFocusChanges = true;
                }
                super.postClose(popup);
            }

            public void setOpen(boolean open) {
                if (CDateTimeCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((CDateTimeCellEditor)CDateTimeCellEditor.this).focusListener).handleFocusChanges = false;
                }
                super.setOpen(open);
            }

            public void setOpen(boolean open, Runnable callback) {
                if (CDateTimeCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((CDateTimeCellEditor)CDateTimeCellEditor.this).focusListener).handleFocusChanges = false;
                }
                super.setOpen(open, callback);
            }

            protected void addTextListener() {
                super.addTextListener();
                ((Text)this.text.getControl()).addTraverseListener(event -> {
                    boolean committed = false;
                    if (event.keyCode == 9 && event.stateMask == SWT.MOD2) {
                        committed = CDateTimeCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                    } else if (event.keyCode == 9 && event.stateMask == 0) {
                        committed = CDateTimeCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                    } else if (event.detail == 2) {
                        CDateTimeCellEditor.this.close();
                    }
                    if (!committed) {
                        event.doit = false;
                    }
                });
            }
        };
        dateControl.setBackground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        dateControl.setForeground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        if ((this.style & 4) == 0) {
            dateControl.setFont((Font)this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        }
        dateControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                boolean commit = event.stateMask != SWT.MOD3;
                SelectionLayer.MoveDirectionEnum move = SelectionLayer.MoveDirectionEnum.NONE;
                if (CDateTimeCellEditor.this.moveSelectionOnEnter && CDateTimeCellEditor.this.editMode == EditModeEnum.INLINE) {
                    if (event.stateMask == 0) {
                        move = SelectionLayer.MoveDirectionEnum.DOWN;
                    } else if (event.stateMask == SWT.MOD2) {
                        move = SelectionLayer.MoveDirectionEnum.UP;
                    }
                }
                if (commit) {
                    CDateTimeCellEditor.this.commit(move);
                }
                if (CDateTimeCellEditor.this.editMode == EditModeEnum.DIALOG) {
                    parent.forceFocus();
                }
            }
        });
        return dateControl;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.dateTime = this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.dateTime.forceFocus();
        return this.dateTime;
    }

    public void setProvideCalendar(boolean provideCalendar) {
        this.provideCalendar = provideCalendar;
    }
}

