/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableIntSetFactory;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableIntSetFactoryImpl;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public final class IntSets {
    public static final ImmutableIntSetFactory immutable = ImmutableIntSetFactoryImpl.INSTANCE;
    public static final MutableIntSetFactory mutable = MutableIntSetFactoryImpl.INSTANCE;

    private IntSets() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <A, B> LazyIterable<IntIntPair> cartesianProduct(IntSet set1, IntSet set2) {
        return IntSets.cartesianProduct(set1, set2, PrimitiveTuples::pair);
    }

    public static <A, B, C> LazyIterable<C> cartesianProduct(IntSet set1, IntSet set2, IntIntToObjectFunction<C> function) {
        return set1.asLazy().flatCollect(first -> set2.asLazy().collect(second -> function.value(first, second)));
    }
}

