/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.swt.graphics.Rectangle;

public class SpanningDataLayer
extends DataLayer {
    public SpanningDataLayer(ISpanningDataProvider dataProvider) {
        super(dataProvider);
    }

    public SpanningDataLayer(ISpanningDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight) {
        super(dataProvider, defaultColumnWidth, defaultRowHeight);
    }

    protected SpanningDataLayer() {
    }

    protected SpanningDataLayer(int defaultColumnWidth, int defaultRowHeight) {
        super(defaultColumnWidth, defaultRowHeight);
    }

    @Override
    public ISpanningDataProvider getDataProvider() {
        return (ISpanningDataProvider)super.getDataProvider();
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount() || rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return null;
        }
        DataCell dataCell = this.getDataProvider().getCellByPosition(columnPosition, rowPosition);
        return new LayerCell(this, columnPosition, rowPosition, dataCell);
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        return super.getBoundsByPosition(cell.getOriginColumnPosition(), cell.getOriginRowPosition());
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        ILayerCell cell = this.getCellByPosition(columnIndex, rowIndex);
        int i = 0;
        while (i < cell.getColumnSpan()) {
            int j = 0;
            while (j < cell.getRowSpan()) {
                super.setDataValue(cell.getOriginColumnPosition() + i, cell.getOriginRowPosition() + j, newValue);
                ++j;
            }
            ++i;
        }
    }
}

