/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class Lowering
implements IOTConstants {
    public Expression lowerExpression(BlockScope scope, Expression expression, TypeBinding unloweredType, TypeBinding requiredType, Expression teamExpression, boolean needNullCheck) {
        int sourceStart = expression.sourceStart;
        int sourceEnd = expression.sourceEnd;
        AstGenerator gen = new AstGenerator(sourceStart, sourceEnd);
        unloweredType = TeamModel.strengthenRoleType(scope.enclosingSourceType(), unloweredType);
        Expression loweringExpr = null;
        TypeBinding expressionType = expression.resolvedType;
        assert (expressionType == null || expressionType.leafComponentType() instanceof ReferenceBinding);
        LocalVariableBinding localVar = null;
        Expression unloweredExpression = expression;
        if (expression instanceof ThisReference || expression instanceof AllocationExpression) {
            needNullCheck = false;
        }
        if (needNullCheck) {
            localVar = this.makeNewLocal(scope, unloweredType, sourceStart, sourceEnd);
            SingleNameReference varRef = gen.singleNameReference(localVar.name);
            varRef.binding = localVar;
            varRef.bits = 2;
            varRef.constant = Constant.NotAConstant;
            varRef.resolvedType = unloweredType;
            unloweredExpression = varRef;
        }
        if (unloweredType.isArrayType()) {
            ArrayLowering trans = new ArrayLowering(teamExpression);
            loweringExpr = trans.lowerArray(scope, unloweredExpression, unloweredType, requiredType);
        } else {
            boolean needMethod;
            RoleTypeBinding roleType = (RoleTypeBinding)unloweredType;
            boolean bl = needMethod = roleType.isRegularInterface() || !roleType.isSiblingRole(scope.enclosingSourceType());
            if (needMethod) {
                MessageSend callLower = gen.messageSend(unloweredExpression, IOTConstants._OT_GETBASE, new Expression[0]);
                callLower.actualReceiverType = unloweredType;
                callLower.constant = Constant.NotAConstant;
                callLower.resolvedType = roleType.baseclass();
                callLower.binding = StandardElementGenerator.getGetBaseMethod(scope, roleType.roleModel, roleType.baseclass());
                loweringExpr = callLower;
            } else {
                FieldReference invokeBaseOnRole = new FieldReference(IOTConstants._OT_BASE, ((long)sourceStart << 32) + (long)sourceEnd);
                ReferenceBinding roleClass = roleType.roleModel.getClassPartBinding();
                TypeReference classRef = gen.typeReference(roleClass);
                if (classRef != null) {
                    CastExpression unloweredExpr = new CastExpression(unloweredExpression, classRef, 1);
                    unloweredExpr.constant = Constant.NotAConstant;
                    unloweredExpr.resolvedType = roleClass;
                    unloweredExpr.bits |= 0x40;
                    invokeBaseOnRole.receiver = unloweredExpr;
                } else {
                    invokeBaseOnRole.receiver = unloweredExpression;
                }
                invokeBaseOnRole.actualReceiverType = roleClass;
                invokeBaseOnRole.resolvedType = roleClass.baseclass();
                invokeBaseOnRole.binding = scope.findField(roleClass, IOTConstants._OT_BASE, invokeBaseOnRole, true);
                invokeBaseOnRole.constant = Constant.NotAConstant;
                loweringExpr = invokeBaseOnRole;
            }
        }
        if (needNullCheck) {
            SingleNameReference lhs = gen.singleNameReference(localVar.name);
            lhs.binding = localVar;
            lhs.resolvedType = unloweredType;
            lhs.bits = 10;
            Assignment assignment = gen.assignment(lhs, expression);
            assignment.constant = Constant.NotAConstant;
            loweringExpr = new CheckedLoweringExpression(expression, gen.nullCheck(assignment), gen.nullLiteral(), loweringExpr, localVar);
            loweringExpr.constant = Constant.NotAConstant;
            loweringExpr.resolvedType = requiredType;
        }
        return loweringExpr;
    }

    @NonNull
    LocalVariableBinding makeNewLocal(BlockScope scope, TypeBinding variableType, int sourceStart, int sourceEnd) {
        char[] name = ("_OT$unlowered$" + sourceStart).toCharArray();
        LocalVariableBinding varBinding = new LocalVariableBinding(name, variableType, 0, false);
        varBinding.declaration = new LocalDeclaration(name, sourceStart, sourceEnd);
        scope.addLocalVariable(varBinding);
        varBinding.setConstant(Constant.NotAConstant);
        varBinding.useFlag = 1;
        return varBinding;
    }

    public static boolean isLoweringConditional(Expression expr) {
        return expr instanceof CheckedLoweringExpression;
    }

    public static Expression unwrapExpression(Expression expression) {
        if (expression instanceof CheckedLoweringExpression) {
            return ((CheckedLoweringExpression)expression).origExpression;
        }
        return null;
    }

    static class CheckedLoweringExpression
    extends ConditionalExpression {
        private final LocalVariableBinding localVar;
        Expression origExpression;

        CheckedLoweringExpression(Expression origExpression, Expression condition, Expression valueIfTrue, Expression valueIfFalse, LocalVariableBinding localVar) {
            super(condition, valueIfTrue, valueIfFalse);
            this.localVar = localVar;
            this.origExpression = origExpression;
        }

        public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
            codeStream.addVisibleLocalVariable(this.localVar);
            super.generateCode(currentScope, codeStream, valueRequired);
        }
    }
}

