/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;

public class WeakenedTypeBinding
extends DependentTypeBinding {
    public final ReferenceBinding weakenedType;

    public WeakenedTypeBinding(DependentTypeBinding declaredType, ReferenceBinding weakenedType, LookupEnvironment environment) {
        super(declaredType, declaredType.arguments, declaredType.enclosingType(), environment);
        this.weakenedType = weakenedType;
        this.roleModel = declaredType.roleModel;
        if (this.type instanceof WeakenedTypeBinding) {
            this.type = ((WeakenedTypeBinding)this.type).type;
        }
        this.initializeDependentType(declaredType._teamAnchor, declaredType._valueParamPosition);
    }

    public static TypeBinding makeWeakenedTypeBinding(DependentTypeBinding declaredType, ReferenceBinding weakenedType, int dimensions) {
        if (declaredType instanceof WeakenedTypeBinding) {
            if (((WeakenedTypeBinding)declaredType).contains(weakenedType)) {
                return declaredType;
            }
            declaredType = ((WeakenedTypeBinding)declaredType).getStrongType();
        }
        if (weakenedType instanceof WeakenedTypeBinding) {
            WeakenedTypeBinding weakenedTypeBinding = (WeakenedTypeBinding)weakenedType;
            weakenedType = weakenedTypeBinding.weakenedType;
        }
        WeakenedTypeBinding leafType = new WeakenedTypeBinding(declaredType, weakenedType, declaredType.environment);
        if (dimensions == 0) {
            return leafType;
        }
        return declaredType.environment.createArrayType(leafType, dimensions);
    }

    boolean contains(TypeBinding other) {
        if (!(other instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding otherStrong = other;
        TypeBinding otherWeak = other;
        if (other instanceof WeakenedTypeBinding) {
            otherWeak = ((WeakenedTypeBinding)other).weakenedType;
            otherStrong = ((WeakenedTypeBinding)other).getStrongType();
        }
        return this.type.isCompatibleWith(otherStrong) && otherWeak.isCompatibleWith(this.weakenedType);
    }

    public char[] constantPoolName() {
        return this.weakenedType.constantPoolName();
    }

    public TypeBinding erasure() {
        return this.weakenedType.erasure();
    }

    protected void registerAnchor() {
    }

    public TypeBinding maybeInstantiate(ITeamAnchor anchor, int dimensions) {
        return ((DependentTypeBinding)this.type).maybeInstantiate(anchor, dimensions);
    }

    public boolean isCompatibleWith(TypeBinding otherType) {
        return this.type.isCompatibleWith(otherType);
    }

    public boolean isProvablyDistinct(TypeBinding otherType) {
        if (super.isProvablyDistinct(otherType)) {
            return true;
        }
        return this.weakenedType.isProvablyDistinct(otherType);
    }

    public DependentTypeBinding getStrongType() {
        return (DependentTypeBinding)this.type;
    }

    public static ReferenceBinding getBytecodeType(TypeBinding returnType) {
        if (returnType instanceof WeakenedTypeBinding) {
            return WeakenedTypeBinding.getBytecodeType(((WeakenedTypeBinding)returnType).weakenedType);
        }
        return (ReferenceBinding)returnType;
    }

    public boolean isSignificantlyWeakened() {
        return this.weakenedType != this.type.getRealType();
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = this.weakenedType.signature();
        return this.signature;
    }

    public static boolean requireWeakening(DependentTypeBinding strongType, ReferenceBinding weakType) {
        if (strongType == weakType) {
            return false;
        }
        if (strongType instanceof WeakenedTypeBinding) {
            return ((WeakenedTypeBinding)strongType).weakenedType == weakType;
        }
        return false;
    }
}

