/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.projects.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.resources.EclipseProjectFactory;
import org.eclipse.oomph.resources.ProjectHandler;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.impl.SourceLocatorImpl;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.projects.ProjectsImportTask;
import org.eclipse.oomph.setup.projects.ProjectsPackage;
import org.eclipse.oomph.setup.projects.ProjectsPlugin;
import org.eclipse.oomph.setup.projects.impl.Messages;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.oomph.util.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsImportTaskImpl
extends SetupTaskImpl
implements ProjectsImportTask {
    protected static final boolean FORCE_EDEFAULT = false;
    protected boolean force = false;
    private static final PropertyFile HISTORY = new PropertyFile(ProjectsPlugin.INSTANCE.getStateLocation().append("import-history.properties").toFile());
    private static final IWorkspaceRoot ROOT = EcorePlugin.getWorkspaceRoot();
    protected EList<SourceLocator> sourceLocators;

    protected ProjectsImportTaskImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectsPackage.Literals.PROJECTS_IMPORT_TASK;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public void setForce(boolean newForce) {
        boolean oldForce = this.force;
        this.force = newForce;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldForce, this.force));
        }
    }

    @Override
    public EList<SourceLocator> getSourceLocators() {
        if (this.sourceLocators == null) {
            this.sourceLocators = new EObjectContainmentEList(SourceLocator.class, (InternalEObject)this, 11);
        }
        return this.sourceLocators;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getSourceLocators()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isForce();
            }
            case 11: {
                return this.getSourceLocators();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setForce((Boolean)newValue);
                return;
            }
            case 11: {
                this.getSourceLocators().clear();
                this.getSourceLocators().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setForce(false);
                return;
            }
            case 11: {
                this.getSourceLocators().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.force;
            }
            case 11: {
                return this.sourceLocators != null && !this.sourceLocators.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (force: ");
        result.append(this.force);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 50;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (this.isForce() || context.getTrigger() == Trigger.MANUAL) {
            return true;
        }
        for (SourceLocator sourceLocator : this.getSourceLocators()) {
            IProject[] projects = this.getProjects(sourceLocator);
            if (projects == null) {
                return true;
            }
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!project.exists()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void perform(SetupTaskContext context) throws Exception {
        HashMap<BackendContainer, IProject> backendContainers = new HashMap<BackendContainer, IProject>();
        MultiStatus status = new MultiStatus(ProjectsPlugin.INSTANCE.getSymbolicName(), 0, Messages.ProjectsImportTaskImpl_Analysis_message, null);
        EList<SourceLocator> sourceLocators = this.getSourceLocators();
        int size = sourceLocators.size();
        IProgressMonitor monitor = context.getProgressMonitor(true);
        monitor.beginTask("", 2 * size);
        try {
            for (SourceLocator sourceLocator : sourceLocators) {
                String rootFolder = sourceLocator.getRootFolder();
                context.log(NLS.bind((String)Messages.ProjectsImportTaskImpl_Importing_message, (Object)rootFolder));
                MultiStatus childStatus = new MultiStatus(ProjectsPlugin.INSTANCE.getSymbolicName(), 0, NLS.bind((String)Messages.ProjectsImportTaskImpl_AnalysisOf_message, (Object)rootFolder), null);
                try {
                    ProjectHandler.Collector collector = new ProjectHandler.Collector();
                    sourceLocator.handleProjects(EclipseProjectFactory.LIST, (ProjectHandler)collector, childStatus, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    if (childStatus.getSeverity() >= 4) {
                        status.add((IStatus)childStatus);
                        continue;
                    }
                    Map projectMap = collector.getProjectMap();
                    for (Map.Entry entry : projectMap.entrySet()) {
                        backendContainers.put((BackendContainer)entry.getValue(), (IProject)entry.getKey());
                    }
                    Set projects = projectMap.keySet();
                    if (projects.isEmpty()) {
                        context.log(Messages.ProjectsImportTaskImpl_NoProjectsFound_message);
                    }
                    this.setProjects(sourceLocator, projects.toArray(new IProject[projectMap.size()]));
                }
                catch (Exception ex) {
                    SourceLocatorImpl.addStatus((MultiStatus)status, (OomphPlugin)ProjectsPlugin.INSTANCE, (String)rootFolder, (Object)ex);
                }
            }
            ProjectsImportTaskImpl.importProjects(backendContainers, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)size));
        }
        finally {
            monitor.done();
        }
        ProjectsPlugin.INSTANCE.coreException((IStatus)status);
    }

    private IProject[] getProjects(SourceLocator sourceLocator) {
        String key = this.getDigest(sourceLocator);
        String value = HISTORY.getProperty(key, null);
        if (value != null) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (String element : XMLTypeFactory.eINSTANCE.createNMTOKENS(value)) {
                projects.add(ROOT.getProject(URI.decode((String)element)));
            }
            return projects.toArray(new IProject[projects.size()]);
        }
        return null;
    }

    private String getDigest(SourceLocator sourceLocator) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            BinaryResourceImpl.EObjectOutputStream eObjectOutputStream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)bytes, null);
            eObjectOutputStream.saveEObject((InternalEObject)sourceLocator, BinaryResourceImpl.EObjectOutputStream.Check.NOTHING);
            bytes.toByteArray();
            return XMLTypeFactory.eINSTANCE.convertBase64Binary(IOUtil.getSHA1((InputStream)new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException ex) {
            ProjectsPlugin.INSTANCE.log(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            ProjectsPlugin.INSTANCE.log(ex);
        }
        return null;
    }

    private void setProjects(SourceLocator sourceLocator, IProject[] projects) {
        String key = this.getDigest(sourceLocator);
        StringBuilder value = new StringBuilder();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (value.length() != 0) {
                value.append(' ');
            }
            value.append(URI.encodeSegment((String)project.getName(), (boolean)false));
            ++n2;
        }
        HISTORY.setProperty(key, value.toString());
    }

    private static int importProjects(final Map<BackendContainer, IProject> backendContainers, IProgressMonitor monitor) throws CoreException {
        if (backendContainers.isEmpty()) {
            return 0;
        }
        final AtomicInteger count = new AtomicInteger();
        IWorkspace workspace = org.eclipse.core.resources.ResourcesPlugin.getWorkspace();
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)backendContainers.size()).detectCancelation();
                try {
                    try {
                        for (Map.Entry entry : backendContainers.entrySet()) {
                            IProject project;
                            BackendContainer backendContainer = (BackendContainer)entry.getKey();
                            if (backendContainer.importIntoWorkspace(project = (IProject)entry.getValue(), (IProgressMonitor)progress.newChild()) != ResourcesUtil.ImportResult.IMPORTED) continue;
                            count.incrementAndGet();
                        }
                    }
                    catch (Exception ex) {
                        ResourcesPlugin.INSTANCE.coreException((Throwable)ex);
                        progress.done();
                    }
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
        return count.get();
    }
}

