/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.addons.splitteraddon.SplitHost;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.FilteredTableBaseHandler;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class CycleViewHandler
extends FilteredTableBaseHandler {
    @Override
    protected Object getInput(WorkbenchPage page) {
        ArrayList refs = new ArrayList();
        EPartService partService = (EPartService)page.getWorkbenchWindow().getService(EPartService.class);
        EModelService modelService = (EModelService)page.getWorkbenchWindow().getService(EModelService.class);
        MPerspective currentPerspective = page.getCurrentPerspective();
        List parts = modelService.findElements((MUIElement)currentPerspective, null, MPart.class, null, 11).stream().filter(p -> !(p.getObject() instanceof SplitHost)).collect(Collectors.toList());
        AtomicBoolean includeEditor = new AtomicBoolean(true);
        parts.stream().sorted((firstPart, secondPart) -> {
            Long firstPartActivationTime = firstPart.getTransientData().getOrDefault("partActivationTime", Long.MIN_VALUE);
            Long secondPartActivationTime = secondPart.getTransientData().getOrDefault("partActivationTime", Long.MIN_VALUE);
            return -firstPartActivationTime.compareTo(secondPartActivationTime);
        }).forEach(part -> {
            if (!partService.isPartOrPlaceholderInPerspective(part.getElementId(), currentPerspective)) {
                return;
            }
            if (part.getTags().contains("Editor")) {
                if (includeEditor.getAndSet(false)) {
                    this.addExistingReference(refs, (MPart)part);
                }
            } else {
                this.addExistingReference(refs, (MPart)part);
            }
        });
        return refs;
    }

    @Override
    protected String getWorkbenchPartReferenceText(WorkbenchPartReference ref) {
        if (ref instanceof EditorReference) {
            return WorkbenchMessages.CyclePartAction_editor;
        }
        if (ref instanceof ViewReference) {
            return ref.getPartName();
        }
        return super.getWorkbenchPartReferenceText(ref);
    }

    protected void addExistingReference(List<IWorkbenchPartReference> refs, MPart part) {
        Object tData = part.getTransientData().get(IWorkbenchPartReference.class.getName());
        if (tData instanceof IWorkbenchPartReference) {
            refs.add((IWorkbenchPartReference)tData);
        }
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        return this.getParametrizedCommand("org.eclipse.ui.window.previousView");
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        return this.getParametrizedCommand("org.eclipse.ui.window.nextView");
    }

    private ParameterizedCommand getParametrizedCommand(String workbenchCommand) {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(workbenchCommand);
        ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
        return parameterizedCommand;
    }

    @Override
    protected String getTableHeader(IWorkbenchPart activePart) {
        return WorkbenchMessages.CyclePartAction_header;
    }
}

