/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public class SimpleInstallationLogPage
extends SimpleInstallerPage {
    public static final int SCROLL_SPEED = 8;
    private ScrolledComposite scrolledComposite;
    private Text text;
    private File installationLogFile;
    private Label logFilePathLabel;

    public SimpleInstallationLogPage(Composite parent, SimpleInstallerDialog dialog) {
        super(parent, dialog, true);
    }

    protected void createContent(Composite container) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 17;
        layout.marginRight = 11;
        layout.marginTop = 39;
        layout.marginBottom = 30;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        container.setLayout((Layout)layout);
        container.setBackgroundMode(2);
        container.setBackground(AbstractSimpleDialog.COLOR_WHITE);
        Label title = new Label(container, 0);
        title.setText("INSTALLATION LOG");
        title.setForeground(UIUtil.getEclipseThemeColor());
        title.setFont(SimpleInstallerDialog.getFont(3, "bold"));
        title.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000008).create());
        this.logFilePathLabel = new Label(container, 0);
        this.logFilePathLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).create());
        this.scrolledComposite = new ScrolledComposite(container, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.text = new Text((Composite)this.scrolledComposite, 10);
        this.scrolledComposite.setContent((Control)this.text);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.text.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Listener[] selectionListeners;
                int value = event.count * 8;
                ScrollBar vbar = SimpleInstallationLogPage.this.scrolledComposite.getVerticalBar();
                vbar.setSelection(vbar.getSelection() - value);
                Listener[] listenerArray = selectionListeners = vbar.getListeners(13);
                int n = selectionListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    listener.handleEvent(event);
                    ++n2;
                }
            }
        });
    }

    public File getReadmeURI() {
        return this.installationLogFile;
    }

    public void setInstallationLogFile(File installationLogFile) {
        if (this.installationLogFile != installationLogFile) {
            this.installationLogFile = installationLogFile;
            if (this.installationLogFile != null && this.installationLogFile.exists()) {
                this.text.setText(this.readLog());
                this.logFilePathLabel.setVisible(true);
                this.logFilePathLabel.setText("Location: " + this.installationLogFile.getAbsolutePath());
            } else {
                this.logFilePathLabel.setVisible(false);
                this.text.setText("No installation log available.");
            }
            this.scrolledComposite.setMinSize(this.text.computeSize(-1, -1));
        }
    }

    private String readLog() {
        return new String(IOUtil.readFile((File)this.installationLogFile));
    }
}

