/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.CouldNotImportProjectException;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseProjectConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseWorkspaceConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.RecursiveImportListener;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;
import org.eclipse.ui.internal.wizards.datatransfer.SubdirectoryOrSameNameSchedulingRule;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class SmartImportJob
extends Job {
    private File rootDirectory;
    private Set<File> directoriesToImport;
    private Set<File> excludedDirectories;
    private boolean discardRootProject;
    private boolean deepChildrenDetection;
    private boolean configureProjects;
    private boolean closeProjectsAfterImport;
    private boolean reconfigureEclipseProjects;
    private IWorkingSet[] workingSets;
    private IProject rootProject;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private ProjectConfiguratorExtensionManager configurationManager;
    private RecursiveImportListener listener;
    protected Map<File, List<ProjectConfigurator>> importProposals;
    private Map<IProject, List<ProjectConfigurator>> report;
    private Map<IPath, Exception> errors;
    private JobGroup crawlerJobGroup;

    public SmartImportJob(File rootDirectory, Set<IWorkingSet> workingSets, boolean configureProjects, boolean recuriveChildrenDetection) {
        super(rootDirectory.getAbsolutePath());
        this.rootDirectory = rootDirectory;
        this.setWorkingSets(workingSets);
        this.configureProjects = configureProjects;
        this.deepChildrenDetection = recuriveChildrenDetection;
        this.report = Collections.synchronizedMap(new HashMap());
        this.errors = Collections.synchronizedMap(new HashMap());
        this.crawlerJobGroup = new JobGroup(DataTransferMessages.SmartImportJob_detectAndConfigureProjects, 0, 1);
    }

    public void setWorkingSets(Set<IWorkingSet> workingSets) {
        this.workingSets = workingSets != null ? workingSets.toArray(new IWorkingSet[workingSets.size()]) : new IWorkingSet[0];
    }

    public File getRoot() {
        return this.rootDirectory;
    }

    public void setDirectoriesToImport(Set<File> directories) {
        this.directoriesToImport = directories;
    }

    public void setExcludedDirectories(Set<File> directories) {
        this.excludedDirectories = directories;
    }

    public void setListener(RecursiveImportListener listener) {
        this.listener = listener;
    }

    public IStatus run(final IProgressMonitor monitor) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean isAutoBuilding = workspace.isAutoBuilding();
            if (isAutoBuilding) {
                description.setAutoBuilding(false);
                workspace.setDescription(description);
            }
            if (this.directoriesToImport != null) {
                this.deepChildrenDetection = false;
                SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DataTransferMessages.SmartImportJob_configuringSelectedDirectories, (int)(this.directoriesToImport.size() * (this.configureProjects ? 3 : 2) + 1));
                Comparator rootToLeafComparator = (arg0, arg1) -> {
                    int lengthDiff = arg0.getAbsolutePath().length() - arg1.getAbsolutePath().length();
                    if (lengthDiff != 0) {
                        return lengthDiff;
                    }
                    return arg0.compareTo((File)arg1);
                };
                TreeSet<File> directories = new TreeSet<File>(rootToLeafComparator);
                directories.addAll(this.directoriesToImport);
                TreeMap leafToRootProjects = new TreeMap(Collections.reverseOrder(rootToLeafComparator));
                final HashSet<IProject> alreadyConfiguredProjects = new HashSet<IProject>();
                loopMonitor.worked(1);
                for (File directoryToImport : directories) {
                    boolean alreadyAnEclipseProject = new File(directoryToImport, ".project").isFile();
                    try {
                        IProject newProject = this.toExistingOrNewProject(directoryToImport, (IProgressMonitor)loopMonitor.split(1), 128);
                        if (alreadyAnEclipseProject) {
                            alreadyConfiguredProjects.add(newProject);
                        }
                        leafToRootProjects.put(directoryToImport, newProject);
                        loopMonitor.worked(1);
                    }
                    catch (CouldNotImportProjectException ex) {
                        Path path = new Path(directoryToImport.getAbsolutePath());
                        if (this.listener != null) {
                            this.listener.errorHappened((IPath)path, ex);
                        }
                        this.errors.put((IPath)path, ex);
                    }
                }
                if (this.configureProjects) {
                    JobGroup multiDirectoriesJobGroup = new JobGroup(DataTransferMessages.SmartImportJob_configuringSelectedDirectories, 20, 1);
                    for (final IProject newProject : leafToRootProjects.values()) {
                        Job directoryJob = new Job(NLS.bind((String)DataTransferMessages.SmartImportJob_configuring, (Object)newProject.getName())){

                            protected IStatus run(IProgressMonitor aMonitor) {
                                try {
                                    SmartImportJob.this.importProjectAndChildrenRecursively((IContainer)newProject, !alreadyConfiguredProjects.contains(newProject), monitor);
                                    return Status.OK_STATUS;
                                }
                                catch (Exception ex) {
                                    return new Status(4, "org.eclipse.ui.ide", ex.getMessage(), (Throwable)ex);
                                }
                            }
                        };
                        directoryJob.setRule((ISchedulingRule)new SubdirectoryOrSameNameSchedulingRule((IResource)newProject));
                        directoryJob.setUser(true);
                        directoryJob.setJobGroup(multiDirectoriesJobGroup);
                        directoryJob.schedule();
                    }
                    multiDirectoriesJobGroup.join(0L, (IProgressMonitor)loopMonitor.split(leafToRootProjects.size()));
                }
            } else {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                File rootProjectFile = new File(this.rootDirectory, ".project");
                boolean isRootANewProject = !rootProjectFile.isFile();
                this.rootProject = this.toExistingOrNewProject(this.rootDirectory, (IProgressMonitor)subMonitor, 0);
                if (this.configureProjects) {
                    this.importProjectAndChildrenRecursively((IContainer)this.rootProject, isRootANewProject, (IProgressMonitor)subMonitor);
                    if (isRootANewProject && this.rootProjectWorthBeingRemoved()) {
                        Display.getDefault().syncExec(() -> {
                            boolean bl = this.discardRootProject = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DataTransferMessages.SmartImportJob_discardRootProject_title, (String)DataTransferMessages.SmartImportJob_discardRootProject_description);
                        });
                        if (this.discardRootProject) {
                            this.rootProject.delete(false, true, (IProgressMonitor)subMonitor);
                            if (isRootANewProject) {
                                rootProjectFile.delete();
                            }
                            this.report.remove(this.rootProject);
                        }
                    }
                }
            }
            if (this.closeProjectsAfterImport) {
                this.report.keySet().forEach(project -> {
                    try {
                        project.close(monitor);
                    }
                    catch (CoreException e) {
                        this.listener.errorHappened(project.getLocation(), (Exception)((Object)e));
                    }
                });
            }
            if (isAutoBuilding) {
                description.setAutoBuilding(true);
                workspace.setDescription(description);
            }
        }
        catch (Exception ex) {
            return new Status(4, "org.eclipse.ui.ide", ex.getMessage(), (Throwable)ex);
        }
        return Status.OK_STATUS;
    }

    protected boolean rootProjectWorthBeingRemoved() {
        if (this.report.size() == 1) {
            return false;
        }
        List<ProjectConfigurator> rootProjectConfigurators = this.report.get(this.rootProject);
        if (rootProjectConfigurators.isEmpty()) {
            return true;
        }
        boolean areOnlyDummyConfigurators = true;
        for (ProjectConfigurator configurator : rootProjectConfigurators) {
            areOnlyDummyConfigurators &= configurator instanceof EclipseProjectConfigurator || configurator instanceof EclipseWorkspaceConfigurator;
        }
        return areOnlyDummyConfigurators;
    }

    private Set<IProject> searchAndImportChildrenProjectsRecursively(IContainer parentContainer, Set<IPath> directoriesToExclude, IProgressMonitor progressMonitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)parentContainer.members().length);
        IPath parentLocation = parentContainer.getLocation();
        if (parentLocation == null) {
            return Collections.emptySet();
        }
        for (IProject processedProjects : Collections.synchronizedSet(this.report.keySet())) {
            if (!parentLocation.equals((Object)processedProjects.getLocation())) continue;
            return Collections.emptySet();
        }
        parentContainer.refreshLocal(1, progressMonitor);
        HashSet<IFolder> childrenToProcess = new HashSet<IFolder>();
        Set<IProject> res = Collections.synchronizedSet(new HashSet());
        IResource[] iResourceArray = parentContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            IResource childResource = iResourceArray[n2];
            if (childResource.getType() == 2 && !childResource.isDerived() && (location = childResource.getLocation()) != null) {
                boolean excluded = false;
                if (directoriesToExclude != null) {
                    for (IPath excludedPath : directoriesToExclude) {
                        if (excludedPath.isPrefixOf(parentLocation) || !excludedPath.isPrefixOf(location)) continue;
                        excluded = true;
                    }
                }
                if (!excluded) {
                    childrenToProcess.add((IFolder)childResource);
                }
            }
            ++n2;
        }
        HashSet<CrawlFolderJob> jobs = new HashSet<CrawlFolderJob>();
        for (IFolder childFolder : childrenToProcess) {
            CrawlFolderJob crawlerJob = new CrawlFolderJob(NLS.bind((String)DataTransferMessages.SmartImportJob_crawling, (Object)SmartImportWizard.toAbsolutePath(childFolder)), childFolder, res);
            if (this.crawlerJobGroup.getMaxThreads() == 0 || this.crawlerJobGroup.getActiveJobs().size() < this.crawlerJobGroup.getMaxThreads()) {
                crawlerJob.setJobGroup(this.crawlerJobGroup);
                jobs.add(crawlerJob);
                crawlerJob.schedule();
                continue;
            }
            crawlerJob.run((IProgressMonitor)subMonitor);
            subMonitor.worked(1);
        }
        for (CrawlFolderJob job : jobs) {
            job.join(0L, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.done();
        return res;
    }

    private Set<IProject> importProjectAndChildrenRecursively(IContainer container, boolean forceFullProjectCheck, IProgressMonitor progressMonitor) throws Exception {
        EclipseProjectConfigurator eclipseProjectConfigurator;
        HashSet<IProject> projectFromCurrentContainer = new HashSet<IProject>();
        IPath containerLocation = container.getLocation();
        if (containerLocation == null) {
            return projectFromCurrentContainer;
        }
        int allWork = 30 + ProjectConfiguratorExtensionManager.getAllExtensionLabels().size() * 5;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)NLS.bind((String)DataTransferMessages.SmartImportJob_inspecting, (Object)SmartImportWizard.toAbsolutePath(container)), (int)allWork);
        boolean isAlreadyAnEclipseProject = false;
        HashSet<ProjectConfigurator> mainProjectConfigurators = new HashSet<ProjectConfigurator>();
        HashSet<IPath> excludedPaths = new HashSet<IPath>();
        if (this.excludedDirectories != null) {
            for (File excludedDirectory : this.excludedDirectories) {
                excludedPaths.add((IPath)new Path(excludedDirectory.getAbsolutePath()));
            }
        }
        container.refreshLocal(2, progressMonitor);
        if (!forceFullProjectCheck && (eclipseProjectConfigurator = new EclipseProjectConfigurator()).shouldBeAnEclipseProject(container, (IProgressMonitor)subMonitor.split(1))) {
            isAlreadyAnEclipseProject = true;
        }
        if (this.configurationManager == null) {
            this.configurationManager = new ProjectConfiguratorExtensionManager();
        }
        List<ProjectConfigurator> activeConfigurators = this.configurationManager.getAllActiveProjectConfigurators(container);
        HashSet<ProjectConfigurator> potentialSecondaryConfigurators = new HashSet<ProjectConfigurator>();
        IProject project = null;
        for (ProjectConfigurator configurator : activeConfigurators) {
            if (configurator instanceof EclipseProjectConfigurator && forceFullProjectCheck) continue;
            if (configurator.shouldBeAnEclipseProject(container, (IProgressMonitor)subMonitor.split(1))) {
                mainProjectConfigurators.add(configurator);
                if (project != null) continue;
                try {
                    project = this.toExistingOrNewProject(containerLocation.toFile(), (IProgressMonitor)subMonitor.split(1), 128);
                }
                catch (CouldNotImportProjectException ex) {
                    this.errors.put(containerLocation, ex);
                    if (this.listener != null) {
                        this.listener.errorHappened(containerLocation, ex);
                    }
                    return projectFromCurrentContainer;
                }
                projectFromCurrentContainer.add(project);
                continue;
            }
            potentialSecondaryConfigurators.add(configurator);
        }
        if (!mainProjectConfigurators.isEmpty()) {
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
        }
        for (ProjectConfigurator configurator : mainProjectConfigurators) {
            SubMonitor childMonitor = subMonitor.split(1);
            if (configurator instanceof EclipseProjectConfigurator || !isAlreadyAnEclipseProject || this.reconfigureEclipseProjects) {
                configurator.configure(project, excludedPaths, (IProgressMonitor)childMonitor);
                this.report.get(project).add(configurator);
                if (this.listener != null) {
                    this.listener.projectConfigured(project, configurator);
                }
            }
            excludedPaths.addAll(this.toPathSet(configurator.getFoldersToIgnore(project, (IProgressMonitor)subMonitor.split(20))));
        }
        if (this.deepChildrenDetection) {
            Set<IProject> allNestedProjects = this.searchAndImportChildrenProjectsRecursively(container, excludedPaths, progressMonitor);
            projectFromCurrentContainer.addAll(allNestedProjects);
        }
        IProject[] iProjectArray = container.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject other = iProjectArray[n2];
            IPath otherLocation = other.getLocation();
            if (otherLocation != null && !containerLocation.equals((Object)otherLocation) && containerLocation.isPrefixOf(otherLocation)) {
                excludedPaths.add(otherLocation);
            }
            ++n2;
        }
        if (mainProjectConfigurators.isEmpty() && (!isAlreadyAnEclipseProject || forceFullProjectCheck)) {
            if (project == null) {
                try {
                    project = this.toExistingOrNewProject(containerLocation.toFile(), (IProgressMonitor)subMonitor.split(1), 128);
                }
                catch (CouldNotImportProjectException ex) {
                    this.errors.put(containerLocation, ex);
                    if (this.listener != null) {
                        this.listener.errorHappened(containerLocation, ex);
                    }
                    return projectFromCurrentContainer;
                }
                projectFromCurrentContainer.add(project);
            }
            project.refreshLocal(1, (IProgressMonitor)subMonitor.split(1));
            progressMonitor.setTaskName(NLS.bind((String)DataTransferMessages.SmartImportJob_continuingConfiguration, (Object)project.getName()));
            for (ProjectConfigurator additionalConfigurator : potentialSecondaryConfigurators) {
                if (!additionalConfigurator.canConfigure(project, excludedPaths, (IProgressMonitor)subMonitor.split(1))) continue;
                additionalConfigurator.configure(project, excludedPaths, (IProgressMonitor)subMonitor.split(1));
                this.report.get(project).add(additionalConfigurator);
                if (this.listener != null) {
                    this.listener.projectConfigured(project, additionalConfigurator);
                }
                excludedPaths.addAll(this.toPathSet(additionalConfigurator.getFoldersToIgnore(project, (IProgressMonitor)subMonitor.split(1))));
            }
        }
        if (project != null) {
            excludedPaths.add(project.getLocation());
        }
        subMonitor.done();
        return projectFromCurrentContainer;
    }

    private Set<IPath> toPathSet(Set<? extends IContainer> resources) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IPath> res = new HashSet<IPath>();
        for (IContainer iContainer : resources) {
            IPath location = iContainer.getLocation();
            if (location == null) continue;
            res.add(location);
        }
        return res;
    }

    private IProject toExistingOrNewProject(File directory, IProgressMonitor progressMonitor, int refreshMode) throws CouldNotImportProjectException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)NLS.bind((String)DataTransferMessages.SmartImportJob_importingProjectIntoWorkspace, (Object)directory.getAbsolutePath()), (int)2);
            IProject project = this.projectAlreadyExistsInWorkspace(directory);
            if (project == null) {
                project = this.createOrImportProject(directory, (IProgressMonitor)subMonitor.split(1));
            }
            subMonitor.setWorkRemaining(1);
            project.open(refreshMode, (IProgressMonitor)subMonitor.split(1));
            if (!this.report.containsKey(project)) {
                this.report.put(project, new ArrayList());
            }
            if (this.listener != null) {
                this.listener.projectCreated(project);
            }
            return project;
        }
        catch (Exception ex) {
            throw new CouldNotImportProjectException(directory, ex);
        }
    }

    private IProject projectAlreadyExistsInWorkspace(File directory) {
        IProject[] iProjectArray = this.workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            File file = SmartImportWizard.toFile(project);
            if (file != null && file.getAbsoluteFile().equals(directory.getAbsoluteFile())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private IProject createOrImportProject(File directory, IProgressMonitor progressMonitor) throws Exception {
        IProjectDescription desc = null;
        File expectedProjectDescriptionFile = new File(directory, ".project");
        if (expectedProjectDescriptionFile.exists()) {
            desc = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(expectedProjectDescriptionFile.getAbsolutePath()));
            String expectedName = desc.getName();
            IProject projectWithSameName = this.workspaceRoot.getProject(expectedName);
            if (projectWithSameName.exists()) {
                if (directory.equals(SmartImportWizard.toFile(projectWithSameName))) {
                    return projectWithSameName;
                }
                throw new CouldNotImportProjectException(directory, NLS.bind((String)DataTransferMessages.SmartImportProposals_anotherProjectWithSameNameExists_description, (Object)expectedName));
            }
        } else {
            String projectName = SmartImportJob.generateNewProjectName(directory, this.workspaceRoot);
            desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        }
        desc.setLocation((IPath)new Path(directory.getAbsolutePath()));
        IProject res = this.workspaceRoot.getProject(desc.getName());
        res.create(desc, progressMonitor);
        PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)res, this.workingSets);
        return res;
    }

    private static String generateNewProjectName(File directory, IWorkspaceRoot root) {
        String projectName = directory.getName();
        if (root.getProject(projectName).exists()) {
            StringBuilder projectNameBuilder = new StringBuilder(projectName);
            File currentDirectory = directory;
            while (currentDirectory.canRead() && directory.getParentFile() != null && root.getProject(projectNameBuilder.toString()).exists()) {
                projectNameBuilder.insert(0, "_");
                projectNameBuilder.insert(0, currentDirectory.getParentFile().getName());
                currentDirectory = currentDirectory.getParentFile();
            }
            if (!root.getProject(projectNameBuilder.toString()).exists()) {
                projectName = projectNameBuilder.toString();
            } else {
                int i = 1;
                do {
                    projectName = String.valueOf(directory.getName()) + '(' + i + ')';
                    ++i;
                } while (root.getProject(projectName).exists());
            }
        }
        return projectName;
    }

    public IProject getRootProject() {
        return this.rootProject;
    }

    public Map<IProject, List<ProjectConfigurator>> getConfiguredProjects() {
        return this.report;
    }

    public Map<IPath, Exception> getErrors() {
        return this.errors;
    }

    public Map<File, List<ProjectConfigurator>> getImportProposals(IProgressMonitor monitor) {
        if (!this.deepChildrenDetection) {
            HashMap<File, List<ProjectConfigurator>> res = new HashMap<File, List<ProjectConfigurator>>();
            res.put(this.rootDirectory, Collections.emptyList());
            return res;
        }
        if (this.importProposals == null) {
            HashMap<File, List<ProjectConfigurator>> res = new HashMap<File, List<ProjectConfigurator>>();
            if (this.configurationManager == null) {
                this.configurationManager = new ProjectConfiguratorExtensionManager();
            }
            List<ProjectConfigurator> activeConfigurators = this.configurationManager.getAllActiveProjectConfigurators(this.rootDirectory);
            SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)activeConfigurators.size());
            for (ProjectConfigurator configurator : activeConfigurators) {
                Set<File> supportedDirectories = configurator.findConfigurableLocations(this.rootDirectory, (IProgressMonitor)loopMonitor.split(1));
                if (supportedDirectories == null) continue;
                for (File supportedDirectory : supportedDirectories) {
                    if (supportedDirectory.isDirectory()) {
                        if (!res.containsKey(supportedDirectory)) {
                            res.put(supportedDirectory, new ArrayList());
                        }
                        ((List)res.get(supportedDirectory)).add(configurator);
                        continue;
                    }
                    IDEWorkbenchPlugin.log("Project detection must return only directories.\n" + supportedDirectory + " is not a directory.\nContributed by " + configurator.getClass().getName());
                }
            }
            for (ProjectConfigurator configurator : activeConfigurators) {
                configurator.removeDirtyDirectories(res);
            }
            this.importProposals = res;
        }
        return this.importProposals;
    }

    public boolean isConfigureProjects() {
        return this.configureProjects;
    }

    public boolean isDetectNestedProjects() {
        return this.deepChildrenDetection;
    }

    public void setDetectNestedProjects(boolean detectNestedProjects) {
        this.deepChildrenDetection = detectNestedProjects;
    }

    void setCloseProjectsAfterImport(boolean closeProjectsAfterImport) {
        this.closeProjectsAfterImport = closeProjectsAfterImport;
    }

    public void resetProposals() {
        this.importProposals = null;
    }

    public Set<File> getDirectoriesToImport() {
        return this.directoriesToImport;
    }

    public boolean belongsTo(Object family) {
        return family == SmartImportJob.class;
    }

    private final class CrawlFolderJob
    extends Job {
        private final IFolder childFolder;
        private final Set<IProject> res;

        private CrawlFolderJob(String name, IFolder childFolder, Set<IProject> res) {
            super(name);
            this.childFolder = childFolder;
            this.res = res;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            SubMonitor subMonitor = null;
            subMonitor = progressMonitor instanceof SubMonitor ? (SubMonitor)progressMonitor : SubMonitor.convert((IProgressMonitor)progressMonitor);
            try {
                Set<IProject> projectFromCurrentContainer = SmartImportJob.this.importProjectAndChildrenRecursively((IContainer)this.childFolder, false, (IProgressMonitor)subMonitor);
                this.res.addAll(projectFromCurrentContainer);
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.ui.ide", ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

