/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;

public class MacroTaskItemProvider
extends SetupTaskItemProvider {
    private static final Method EXPAND_MACRO_METHOD;

    static {
        Method expandMacroTaskMethod = null;
        try {
            Class setupTaskPerformer = CommonPlugin.loadClass((String)"org.eclipse.oomph.setup.core", (String)"org.eclipse.oomph.setup.internal.core.SetupTaskPerformer");
            expandMacroTaskMethod = setupTaskPerformer.getMethod("expand", MacroTask.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EXPAND_MACRO_METHOD = expandMacroTaskMethod;
    }

    public MacroTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addMacroPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addMacroPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MacroTask_macro_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MacroTask_macro_feature", "_UI_MacroTask_type"), (EStructuralFeature)SetupPackage.Literals.MACRO_TASK__MACRO, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupPackage.Literals.MACRO_TASK__ARGUMENTS);
            this.childrenFeatures.add(SetupPackage.Literals.MACRO_TASK__MACRO);
        }
        return this.childrenFeatures;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public boolean hasChildren(Object object) {
        return !this.isDirectlyRecursive(object) && super.hasChildren(object);
    }

    protected boolean isDirectlyRecursive(Object object) {
        MacroTask macroTask = (MacroTask)object;
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)macroTask);
        return rootContainer == macroTask.getMacro();
    }

    public Collection<?> getChildren(Object object) {
        if (this.isDirectlyRecursive(object)) {
            return Collections.emptyList();
        }
        ArrayList<PreviewDelegatingWrapper> children = super.getChildren(object);
        CompoundTask expandedMacroTask = this.expandMacroTask(object);
        if (expandedMacroTask != null) {
            ArrayList<PreviewDelegatingWrapper> extendedChildren = new ArrayList<PreviewDelegatingWrapper>(children);
            String name = expandedMacroTask.getName();
            expandedMacroTask.setName(StringUtil.isEmpty((String)name) ? this.getString("_UI_MacroPreview_label") : this.getString("_UI_MacroPrefixedPreview_label", new Object[]{name}));
            extendedChildren.add(new PreviewDelegatingWrapper(expandedMacroTask, object, this.adapterFactory));
            children = extendedChildren;
        }
        return children;
    }

    protected CompoundTask expandMacroTask(Object object) {
        if (EXPAND_MACRO_METHOD != null) {
            EObject eContainer;
            CompoundTask expandedMacro = (CompoundTask)ReflectUtil.invokeMethod((Method)EXPAND_MACRO_METHOD, null, (Object[])new Object[]{object});
            if (expandedMacro != null && (eContainer = expandedMacro.eContainer()) instanceof Macro) {
                Macro macro = (Macro)eContainer;
                macro.setLogicalContainer((MacroTask)object);
            }
            return expandedMacro;
        }
        return null;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (feature == SetupPackage.Literals.MACRO_TASK__MACRO) {
            return new DelegatingWrapperItemProvider(value, object, feature, index, this.adapterFactory){

                public Object getImage(Object object) {
                    Object image = super.getImage(object);
                    ArrayList<Object> images = new ArrayList<Object>(2);
                    images.add(image);
                    images.add(SetupEditPlugin.INSTANCE.getImage("MacroOverlay.png"));
                    images.add(SetupEditPlugin.INSTANCE.getImage("LinkOverlay"));
                    return new ComposedImage(images);
                }

                public Object getFont(Object object) {
                    return ITALIC_FONT;
                }

                public Object getForeground(Object object) {
                    Object foreground = super.getForeground(object);
                    return foreground == null ? RecursionSafeDelegatingWrapper.FOREGROUND_COLOR : foreground;
                }

                protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
                    return new RecursionSafeDelegatingWrapper(value, owner, adapterFactory);
                }
            };
        }
        return super.createWrapper(object, feature, value, index);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    private Object getImageGen(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MacroTask"));
    }

    public Object getImage(Object object) {
        Object image = this.getImageGen(object);
        return MacroTaskItemProvider.getRecursiveOverlayImage(this.isDirectlyRecursive(object), false, image);
    }

    protected static Object getRecursiveOverlayImage(boolean isRecursive, boolean isMacro, Object image) {
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(image);
        if (isRecursive) {
            images.add(SetupEditPlugin.INSTANCE.getImage("DeletedOverlay"));
        }
        if (isMacro) {
            images.add(SetupEditPlugin.INSTANCE.getImage("MacroOverlay.png"));
        }
        return images.size() == 1 ? image : new ComposedImage(images);
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        MacroTask macroTask = (MacroTask)object;
        String id = macroTask.getID();
        Macro macro = macroTask.getMacro();
        String label = macro != null ? macro.getLabel() : null;
        return String.valueOf(StringUtil.isEmpty((String)label) ? this.getString("_UI_MacroTask_type") : label) + " : " + (StringUtil.isEmpty((String)id) ? "?" : id);
    }

    private void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MacroTask.class)) {
            case 10: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.notifyChangedGen(notification);
        switch (notification.getFeatureID(MacroTask.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
    }

    private void collectNewChildDescriptorsGen(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.MACRO_TASK__ARGUMENTS, SetupFactory.eINSTANCE.createArgument()));
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        MacroTask macroTask = (MacroTask)object;
        Macro macro = macroTask.getMacro();
        if (macro != null) {
            HashSet<Parameter> boundParameters = new HashSet<Parameter>();
            for (Argument argument : macroTask.getArguments()) {
                boundParameters.add(argument.getParameter());
            }
            for (Parameter parameter : macro.getParameters()) {
                if (boundParameters.contains(parameter)) continue;
                Argument argument = SetupFactory.eINSTANCE.createArgument();
                argument.setParameter(parameter);
                String defaultValue = parameter.getDefaultValue();
                if (defaultValue == null) {
                    argument.setValue(parameter.getName() + "_value");
                }
                newChildDescriptors.add(this.createChildParameter(SetupPackage.Literals.MACRO_TASK__ARGUMENTS, argument));
            }
        }
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        String name;
        Argument argument;
        Parameter parameter;
        String result = super.getCreateChildText(owner, feature, child, selection);
        if (feature == SetupPackage.Literals.MACRO_TASK__ARGUMENTS && (parameter = (argument = (Argument)child).getParameter()) != null && !StringUtil.isEmpty((String)(name = parameter.getName()))) {
            result = String.valueOf(result) + ' ' + this.getString("_UI_MacroArgumentSuffix_label", new Object[]{name});
            return result;
        }
        return result;
    }

    private static class PreviewDelegatingWrapper
    extends DelegatingWrapperItemProvider {
        private static final URI FOREGROUND_COLOR = URI.createURI((String)"color://rgb/85/113/138");

        public PreviewDelegatingWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
            super(value, owner, adapterFactory);
        }

        public Object getFont(Object object) {
            return ITALIC_FONT;
        }

        public Object getForeground(Object object) {
            return FOREGROUND_COLOR;
        }

        public Object getImage(Object object) {
            Object image = super.getImage(object);
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(SetupEditPlugin.INSTANCE.getImage("PreviewOverlay.png"));
            return new ComposedImage(images);
        }

        protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
            return new PreviewDelegatingWrapper(value, owner, adapterFactory);
        }
    }

    private static class RecursionSafeDelegatingWrapper
    extends DelegatingWrapperItemProvider {
        private static final URI FOREGROUND_COLOR = URI.createURI((String)"color://rgb/138/110/85");

        public RecursionSafeDelegatingWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
            super(value, owner, adapterFactory);
        }

        protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
            return new RecursionSafeDelegatingWrapper(value, owner, adapterFactory);
        }

        public Object getFont(Object object) {
            return ITALIC_FONT;
        }

        public Object getForeground(Object object) {
            return FOREGROUND_COLOR;
        }

        public Object getImage(Object object) {
            Object image = super.getImage(object);
            return MacroTaskItemProvider.getRecursiveOverlayImage(this.isRecursive(), true, image);
        }

        public boolean isRecursive() {
            EObject eContainer;
            Object unwrappedValue = AdapterFactoryEditingDomain.unwrap((Object)this.value);
            boolean isRecursive = this.isRecursive(this.owner, unwrappedValue);
            if (!isRecursive && unwrappedValue instanceof EObject && (eContainer = ((EObject)unwrappedValue).eContainer()) instanceof Macro) {
                Macro macro = (Macro)eContainer;
                isRecursive = this.isRecursive(this.owner, macro.getLogicalContainer());
            }
            return isRecursive;
        }

        protected boolean isRecursive(Object parent, Object guard) {
            Object unwrap = AdapterFactoryEditingDomain.unwrap((Object)parent);
            if (unwrap == guard) {
                return true;
            }
            if (parent instanceof ITreeItemContentProvider) {
                Object grandParent = ((ITreeItemContentProvider)parent).getParent(parent);
                return this.isRecursive(grandParent, guard);
            }
            return false;
        }

        public boolean hasChildren(Object object) {
            return !this.isRecursive() && super.hasChildren(object);
        }

        protected void updateChildren() {
            if (!this.isRecursive()) {
                super.updateChildren();
            } else {
                this.delegateChildren = Collections.emptyList();
            }
        }

        public Collection<?> getChildren(Object object) {
            Collection children = super.getChildren(object);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                Object value = ((RecursionSafeDelegatingWrapper)((Object)child)).getValue();
                if (!(value instanceof PreviewDelegatingWrapper)) continue;
                it.remove();
                break;
            }
            return children;
        }
    }
}

