/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.widgets.Display;

abstract class DragAgent {
    private static final String DRAG_PLACEHOLDER_ID = "Drag Placerholder";
    protected MUIElement dragElement;
    protected DnDManager dndManager;
    private MUIElement dragPH = null;
    protected DropAgent dropAgent = null;

    public abstract MUIElement getElementToDrag(DnDInfo var1);

    public DragAgent(DnDManager manager) {
        this.dndManager = manager;
    }

    public MUIElement getDragElement() {
        return this.dragElement;
    }

    public boolean canDrag(DnDInfo info) {
        this.dragElement = this.getElementToDrag(info);
        return this.dragElement != null;
    }

    public void dragStart(DnDInfo info) {
        if (this.dragElement.getParent() != null) {
            if (this.dragElement instanceof MStackElement) {
                this.dragPH = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
            } else if (this.dragElement instanceof MPartStack) {
                this.dragPH = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            } else if (this.dragElement instanceof MTrimElement) {
                this.dragPH = MenuFactoryImpl.eINSTANCE.createToolControl();
            }
            this.dragPH.setElementId(DRAG_PLACEHOLDER_ID);
            this.dragPH.setToBeRendered(false);
            List kids = this.dragElement.getParent().getChildren();
            kids.add(kids.indexOf(this.dragElement), this.dragPH);
        }
        this.dropAgent = this.dndManager.getDropAgent(this.dragElement, info);
        if (this.dropAgent != null) {
            this.dropAgent.dragEnter(this.dragElement, info);
        }
    }

    public void track(DnDInfo info) {
        DropAgent newDropAgent = this.dndManager.getDropAgent(this.dragElement, info);
        if (newDropAgent == this.dropAgent) {
            if (this.dropAgent != null) {
                this.dropAgent.track(this.dragElement, info);
            }
        } else {
            if (this.dropAgent != null) {
                this.dropAgent.dragLeave(this.dragElement, info);
            }
            this.dropAgent = newDropAgent;
            if (this.dropAgent != null) {
                this.dropAgent.dragEnter(this.dragElement, info);
            } else {
                this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
            }
        }
    }

    public void cancelDrag() {
        if (this.dragPH == null) {
            return;
        }
        List phParentsKids = this.dragPH.getParent().getChildren();
        if (phParentsKids.indexOf(this.dragElement) != phParentsKids.indexOf(this.dragPH) + 1) {
            this.dragElement.setToBeRendered(false);
            if (this.dragElement.getParent() != null) {
                this.dragElement.getParent().getChildren().remove(this.dragElement);
            }
            phParentsKids.add(phParentsKids.indexOf(this.dragPH) + 1, this.dragElement);
            this.dragElement.setVisible(true);
            this.dragElement.setToBeRendered(true);
        }
    }

    public void dragFinished(boolean performDrop, DnDInfo info) {
        boolean isNoDrop;
        boolean bl = isNoDrop = this.dndManager.getDragShell().getCursor() == Display.getCurrent().getSystemCursor(20);
        if (performDrop && this.dropAgent != null && !isNoDrop) {
            this.dropAgent.drop(this.dragElement, info);
        } else {
            this.cancelDrag();
        }
        if (this.dropAgent != null) {
            this.dropAgent.dragLeave(this.dragElement, info);
        }
        if (this.dragPH == null) {
            return;
        }
        if (this.dragPH != null) {
            this.dragPH.getParent().getChildren().remove(this.dragPH);
            this.dragPH = null;
        }
        this.dragElement = null;
    }

    public void dispose() {
    }
}

