/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.LinkedResourcesPreferencePage;
import org.eclipse.ui.internal.ide.dialogs.RelativePathVariableGroup;

public class ImportTypeDialog
extends TrayDialog {
    public static final int IMPORT_COPY = 1;
    public static final int IMPORT_FILES_ONLY = 16;
    public static final int IMPORT_LINK = 4;
    public static final int IMPORT_MOVE = 8;
    public static final int IMPORT_NONE = 0;
    public static final int IMPORT_VIRTUAL_FOLDERS_AND_LINKS = 2;
    private Button copyButton = null;
    private int currentSelection;
    private Button linkButton = null;
    private Button moveButton = null;
    private int operationMask;
    private String preferredVariable;
    private IResource receivingResource = null;
    private Button shadowCopyButton = null;
    private String variable = null;
    private RelativePathVariableGroup relativePathVariableGroup;

    public ImportTypeDialog(Shell shell, int dropOperation, IResource[] sources, IContainer target) {
        this(shell, ImportTypeDialog.selectAppropriateMask(dropOperation, sources, target), RelativePathVariableGroup.getPreferredVariable(sources, target));
    }

    public ImportTypeDialog(Shell shell, int dropOperation, String[] names, IContainer target) {
        this(shell, ImportTypeDialog.selectAppropriateMask(dropOperation, names, target), RelativePathVariableGroup.getPreferredVariable(names, target));
    }

    private ImportTypeDialog(Shell parentShell, int operationMask, String preferredVariable) {
        super(parentShell);
        IPreferenceStore store;
        this.preferredVariable = preferredVariable;
        this.operationMask = operationMask;
        this.currentSelection = 0;
        String tmp = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE");
        if (tmp.length() > 0) {
            this.currentSelection = Integer.parseInt(tmp);
        }
        this.currentSelection &= operationMask;
        if (this.currentSelection == 0) {
            this.currentSelection = this.hasFlag(1) ? 1 : 8;
        }
        if ((store = IDEWorkbenchPlugin.getDefault().getPreferenceStore()).getBoolean("IMPORT_FILES_AND_FOLDERS_RELATIVE")) {
            this.variable = preferredVariable;
        }
    }

    public boolean close() {
        return super.close();
    }

    public int getSelection() {
        return this.currentSelection;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setResource(IResource resource) {
        this.receivingResource = resource;
    }

    private boolean hasFlag(int flag) {
        return (this.operationMask & flag) != 0;
    }

    private String readContextPreference(String key) {
        String value = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        String[] stringArray = value.split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyPair = stringArray[n2];
            String[] element = keyPair.split(",");
            if (element.length == 2 && element[0].equals(Integer.toString(this.operationMask))) {
                return element[1];
            }
            ++n2;
        }
        return "";
    }

    private void refreshSelection() {
        if (this.copyButton != null) {
            this.copyButton.setSelection(this.currentSelection == 1);
        }
        if (this.shadowCopyButton != null) {
            this.shadowCopyButton.setSelection(this.currentSelection == 2);
        }
        if (this.linkButton != null) {
            this.linkButton.setSelection(this.currentSelection == 4);
        }
        if (this.moveButton != null) {
            this.moveButton.setSelection(this.currentSelection == 8);
        }
        if (this.relativePathVariableGroup != null) {
            this.relativePathVariableGroup.setEnabled((this.currentSelection & 6) != 0);
        }
    }

    private void writeContextPreference(String key, String value) {
        String oldValue = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(key);
        StringBuffer buffer = new StringBuffer();
        String[] keyPairs = oldValue.split(":");
        boolean found = false;
        int i = 0;
        while (i < keyPairs.length) {
            String[] element;
            if (i > 0) {
                buffer.append(":");
            }
            if ((element = keyPairs[i].split(",")).length == 2) {
                if (element[0].equals(Integer.toString(this.operationMask))) {
                    buffer.append(String.valueOf(element[0]) + "," + value);
                    found = true;
                } else {
                    buffer.append(keyPairs[i]);
                }
            }
            ++i;
        }
        if (!found) {
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append(String.valueOf(Integer.toString(this.operationMask)) + "," + value);
        }
        String newValue = buffer.toString();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(key, newValue);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE", Integer.toString(this.currentSelection));
            IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
            store.putValue("IMPORT_FILES_AND_FOLDERS_RELATIVE", Boolean.toString(this.variable != null));
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = (this.operationMask & 0x10) != 0 ? IDEWorkbenchMessages.ImportTypeDialog_titleFilesOnly : IDEWorkbenchMessages.ImportTypeDialog_title;
        shell.setText(title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.import_type_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        boolean linkIsOnlyChoice;
        boolean bl = linkIsOnlyChoice = this.hasFlag(4) && !this.hasFlag(9) && (!this.hasFlag(2) || this.hasFlag(16));
        if (!linkIsOnlyChoice) {
            this.createMessageArea(parent);
        }
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        int indent = linkIsOnlyChoice ? 0 : this.convertWidthInCharsToPixels(3);
        layout.marginWidth += indent;
        composite.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportTypeDialog.this.currentSelection = (Integer)e.widget.getData();
                ImportTypeDialog.this.refreshSelection();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportTypeDialog.this.currentSelection = (Integer)e.widget.getData();
                ImportTypeDialog.this.refreshSelection();
            }
        };
        if (this.hasFlag(1)) {
            this.copyButton = new Button(composite, 16);
            this.copyButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_copyFiles : IDEWorkbenchMessages.ImportTypeDialog_copyFilesAndDirectories);
            gridData = new GridData(768);
            this.copyButton.setLayoutData((Object)gridData);
            this.copyButton.setData((Object)1);
            this.copyButton.addSelectionListener(listener);
            this.copyButton.setFont(parent.getFont());
        }
        if (this.hasFlag(8)) {
            this.moveButton = new Button(composite, 16);
            this.moveButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_moveFiles : IDEWorkbenchMessages.ImportTypeDialog_moveFilesAndDirectories);
            gridData = new GridData(768);
            this.moveButton.setLayoutData((Object)gridData);
            this.moveButton.setData((Object)8);
            this.moveButton.addSelectionListener(listener);
            this.moveButton.setFont(parent.getFont());
        }
        if (this.hasFlag(4) && !linkIsOnlyChoice) {
            this.linkButton = new Button(composite, 16);
            this.linkButton.setText(this.hasFlag(16) ? IDEWorkbenchMessages.ImportTypeDialog_linkFiles : IDEWorkbenchMessages.ImportTypeDialog_createLinks);
            gridData = new GridData(768);
            this.linkButton.setLayoutData((Object)gridData);
            this.linkButton.setData((Object)4);
            this.linkButton.addSelectionListener(listener);
            this.linkButton.setFont(parent.getFont());
        }
        if (this.hasFlag(2) && !this.hasFlag(16)) {
            this.shadowCopyButton = new Button(composite, 16);
            this.shadowCopyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_recreateFilesAndDirectories);
            gridData = new GridData(768);
            this.shadowCopyButton.setLayoutData((Object)gridData);
            this.shadowCopyButton.setData((Object)2);
            this.shadowCopyButton.addSelectionListener(listener);
            this.shadowCopyButton.setFont(parent.getFont());
        }
        if (this.hasFlag(6)) {
            this.relativePathVariableGroup = new RelativePathVariableGroup(new RelativePathVariableGroup.IModel(){

                @Override
                public IResource getResource() {
                    return ImportTypeDialog.this.receivingResource;
                }

                @Override
                public void setVariable(String string) {
                    ImportTypeDialog.this.variable = string;
                }

                @Override
                public String getVariable() {
                    return ImportTypeDialog.this.variable;
                }
            });
            int groupIndent = 0;
            if (!linkIsOnlyChoice) {
                Button tmp = new Button(composite, 32);
                tmp.setText(".");
                groupIndent = tmp.computeSize((int)-1, (int)-1).x;
                tmp.dispose();
                Label tmpLabel = new Label(composite, 0);
                tmpLabel.setText(".");
                groupIndent -= tmpLabel.computeSize((int)-1, (int)-1).x;
                tmpLabel.dispose();
            }
            Composite variableGroup = new Composite(composite, 0);
            gridData = new GridData(4, 4, true, true);
            gridData.horizontalIndent = groupIndent;
            variableGroup.setLayoutData((Object)gridData);
            variableGroup.setFont(parent.getFont());
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            variableGroup.setLayout((Layout)layout);
            this.relativePathVariableGroup.createContents(variableGroup);
            this.relativePathVariableGroup.setSelection(this.variable != null);
            if (this.variable != null) {
                this.relativePathVariableGroup.selectVariable(this.variable);
            } else {
                this.relativePathVariableGroup.selectVariable(this.preferredVariable);
            }
        }
        if (linkIsOnlyChoice) {
            this.currentSelection = 4;
            parent.getShell().setText(IDEWorkbenchMessages.ImportTypeDialog_titleFilesLinking);
        }
        this.createLinkControl(parent);
        this.refreshSelection();
        return composite;
    }

    private Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 131136);
        link.setText(IDEWorkbenchMessages.ImportTypeDialog_configureSettings);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTypeDialog.this.openSettingsPage();
            }
        });
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        link.setLayoutData((Object)gridData);
        link.setFont(composite.getFont());
        return link;
    }

    protected void openSettingsPage() {
        String prefID = LinkedResourcesPreferencePage.PREF_ID;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)prefID, (String[])new String[]{prefID}, null).open();
    }

    protected Control createMessageArea(Composite parent) {
        String message;
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        String string = message = (this.operationMask & 0x10) != 0 ? IDEWorkbenchMessages.ImportTypeDialog_questionFilesOnly : IDEWorkbenchMessages.ImportTypeDialog_question;
        if (message != null) {
            Label messageLabel = new Label(composite, 64);
            messageLabel.setFont(parent.getFont());
            messageLabel.setText(message);
            gridData = new GridData(4, 1, true, false);
            messageLabel.setLayoutData((Object)gridData);
        }
        return composite;
    }

    private static boolean areOnlyFiles(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() != 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean areOnlyFiles(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File file = new File(name);
            if (file.exists() && !file.isFile()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static int selectAppropriateMask(int dropOperation, IResource[] resources, IContainer target) {
        int mask = 6;
        if (!target.isVirtual() && dropOperation != 4) {
            mask |= 1;
        }
        if (ImportTypeDialog.areOnlyFiles(resources)) {
            mask |= 0x10;
        }
        return mask;
    }

    private static int selectAppropriateMask(int dropOperation, String[] names, IContainer target) {
        int mask = 6;
        if (!target.isVirtual() && dropOperation != 4) {
            mask |= 1;
        }
        if (ImportTypeDialog.areOnlyFiles(names)) {
            mask |= 0x10;
        }
        return mask;
    }
}

