/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.util.Map;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroSeparator;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.osgi.framework.Bundle;

public class IntroModelSerializer {
    private StringBuffer buffer = new StringBuffer();
    private boolean filter;

    public IntroModelSerializer(IntroModelRoot root) {
        this(root, false);
    }

    public IntroModelSerializer(IntroModelRoot root, boolean filter) {
        this.filter = filter;
        this.printModelRootInfo(root, this.buffer);
        AbstractIntroPage rootPage = root.getHomePage();
        this.printHomePage(rootPage, this.buffer);
        this.printPageChildren(rootPage, this.buffer);
        IntroPage[] pages = root.getPages();
        this.printPages(pages, this.buffer);
        this.buffer.append("\n\n");
        this.printModelFlagTests(root, this.buffer);
    }

    private String filterURL(String url) {
        if (this.filter && url != null && url.startsWith("file:/")) {
            return "file:/<filtered>" + url.substring(url.lastIndexOf(47));
        }
        return url;
    }

    private void printModelRootInfo(IntroModelRoot model, StringBuffer text) {
        text.append("\nIntro Model Content:");
        text.append("\n======================");
        text.append("\n\nModel has valid config = " + model.hasValidConfig());
        text.append("\nPresentation Kind = " + model.getPresentation().getImplementationKind());
        text.append("\nPresentation Shared Style = " + model.getPresentation().getImplementationStyles());
        text.append("\nPresentation type = " + model.getPresentation().getType());
        text.append("\nHome page id = " + model.getPresentation().getHomePageId());
        IntroHead headContent = model.getPresentation().getHead();
        if (headContent != null) {
            text.append("\nPresentation Shared Head = " + headContent.getSrc());
        }
        text.append("\nNumber of pages (not including Root Page) = " + model.getPages().length);
        text.append("\nNumber of shared groups = " + model.getChildrenOfType(16).length);
        text.append("\nNumber of unresolved extensions = " + model.getChildrenOfType(1024).length);
    }

    private void printHomePage(AbstractIntroPage rootPage, StringBuffer text) {
        text.append("\n\nHOME PAGE: ");
        text.append("\n--------------");
        text.append("\n\tis dynamic= " + ((IntroModelRoot)rootPage.getParent()).isDynamic());
        text.append("\n\tid = " + rootPage.getId());
        text.append("\n\ttitle = " + rootPage.getTitle());
        text.append("\n\tstyle = " + this.filterURL(rootPage.getStyle()));
        text.append("\n\talt-style = " + this.filterURL(rootPage.getAltStyle()));
        text.append("\n\turl = " + rootPage.getUrl());
        text.append("\n\tstyle-id = " + rootPage.getStyleId());
        this.printPageStyles(rootPage, text);
    }

    private void printPageStyles(AbstractIntroPage page, StringBuffer text) {
        text.append("\n\tpage styles are = ");
        String[] styles = page.getStyles();
        int i = 0;
        while (i < styles.length) {
            text.append(this.filterURL(String.valueOf(styles[i]) + "\n\t\t\t"));
            ++i;
        }
        text.append("\n\tpage alt-styles are = ");
        Map<String, Bundle> altStylesHashtable = page.getAltStyles();
        if (altStylesHashtable == null) {
            return;
        }
        for (Map.Entry<String, Bundle> entry : altStylesHashtable.entrySet()) {
            text.append(String.valueOf(this.filterURL(entry.getKey())) + " from " + entry.getValue().getSymbolicName());
            text.append("\n\t\t");
        }
    }

    private void printPageChildren(AbstractIntroPage page, StringBuffer text) {
        text.append("\n\tpage children = " + page.getChildren().length);
        text.append("\n");
        this.printContainerChildren(page, text, "\n\t\t");
    }

    private void printContainerChildren(AbstractIntroContainer container, StringBuffer text, String indent) {
        AbstractIntroElement[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            int childType = children[i].getType();
            switch (childType) {
                case 131071: {
                    text.append("SHOULD NEVER BE HERE");
                    break;
                }
                case 16: {
                    this.printGroup(text, (IntroGroup)children[i], indent);
                    break;
                }
                case 64: {
                    this.printLink(text, (IntroLink)children[i], indent);
                    break;
                }
                case 512: {
                    this.printText(text, (IntroText)children[i], indent);
                    break;
                }
                case 128: {
                    this.printImage(text, (IntroImage)children[i], indent);
                    break;
                }
                case 524288: {
                    this.printSeparator(text, (IntroSeparator)children[i], indent);
                    break;
                }
                case 32: {
                    this.printHtml(text, (IntroHTML)children[i], indent);
                    break;
                }
                case 256: {
                    this.printInclude(text, (IntroInclude)children[i], indent);
                    break;
                }
                case 2048: {
                    this.printHead(text, (IntroHead)children[i], indent);
                    break;
                }
                case 4096: {
                    this.printPageTitle(text, (IntroPageTitle)children[i], indent);
                    break;
                }
                case 8192: {
                    this.printAnchor(text, (IntroAnchor)children[i], indent);
                    break;
                }
                case 16384: {
                    this.printContentProvidor(text, (IntroContentProvider)children[i], indent);
                }
            }
            ++i;
        }
    }

    private void printGroup(StringBuffer text, IntroGroup group, String indent) {
        text.append(String.valueOf(indent) + "GROUP: id = " + group.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "label = " + group.getLabel());
        text.append(String.valueOf(indent) + "children = " + group.getChildren().length);
        text.append(String.valueOf(indent) + "style-id = " + group.getStyleId());
        this.printContainerChildren(group, text, String.valueOf(indent) + "\t\t");
    }

    private void printLink(StringBuffer text, IntroLink link, String indent) {
        text.append(String.valueOf(indent) + "LINK: id = " + link.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "label = " + link.getLabel());
        text.append(String.valueOf(indent) + "text = " + link.getText());
        text.append(String.valueOf(indent) + "url = " + link.getUrl());
        text.append(String.valueOf(indent) + "style-id = " + link.getStyleId());
    }

    private void printText(StringBuffer text, IntroText introText, String indent) {
        text.append(String.valueOf(indent) + "TEXT: id = " + introText.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "text = " + introText.getText());
        text.append(String.valueOf(indent) + "style-id = " + introText.getStyleId());
    }

    private void printImage(StringBuffer text, IntroImage image, String indent) {
        text.append(String.valueOf(indent) + "IMAGE: id = " + image.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "src = " + image.getSrc());
        text.append(String.valueOf(indent) + "alt = " + image.getAlt());
        text.append(String.valueOf(indent) + "style-id = " + image.getStyleId());
    }

    private void printSeparator(StringBuffer text, IntroSeparator sep, String indent) {
        text.append(String.valueOf(indent) + "HR: id = " + sep.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "style-id = " + sep.getStyleId());
    }

    private void printHtml(StringBuffer text, IntroHTML html, String indent) {
        text.append(String.valueOf(indent) + "HTML: id = " + html.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "src = " + html.getSrc());
        text.append(String.valueOf(indent) + "isInlined = " + html.isInlined());
        text.append(String.valueOf(indent) + "style-id = " + html.getStyleId());
        if (html.getIntroImage() != null) {
            this.printImage(text, html.getIntroImage(), String.valueOf(indent) + "\t\t");
        }
        if (html.getIntroText() != null) {
            this.printText(text, html.getIntroText(), String.valueOf(indent) + "\t\t");
        }
    }

    private void printInclude(StringBuffer text, IntroInclude include, String indent) {
        text.append(String.valueOf(indent) + "INCLUDE: configId = " + include.getConfigId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "path = " + include.getPath());
        text.append(String.valueOf(indent) + "merge-style = " + include.getMergeStyle());
    }

    private void printHead(StringBuffer text, IntroHead head, String indent) {
        text.append(String.valueOf(indent) + "HEAD: src = " + head.getSrc());
    }

    private void printPageTitle(StringBuffer text, IntroPageTitle title, String indent) {
        text.append(String.valueOf(indent) + "TITLE: id = " + title.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "title = " + title.getTitle());
        text.append(String.valueOf(indent) + "style-id = " + title.getStyleId());
    }

    private void printAnchor(StringBuffer text, IntroAnchor anchor, String indent) {
        text.append(String.valueOf(indent) + "ANCHOR: id = " + anchor.getId());
    }

    private void printContentProvidor(StringBuffer text, IntroContentProvider provider, String indent) {
        text.append(String.valueOf(indent) + "CONTENT PROVIDER: id = " + provider.getId());
        indent = String.valueOf(indent) + "\t\t";
        text.append(String.valueOf(indent) + "class = " + provider.getClassName());
        text.append(String.valueOf(indent) + "pluginId = " + provider.getPluginId());
        if (provider.getIntroText() != null) {
            this.printText(text, provider.getIntroText(), String.valueOf(indent) + "\t\t");
        }
    }

    private void printPages(IntroPage[] pages, StringBuffer text) {
        int i = 0;
        while (i < pages.length) {
            text.append("\n\nPAGE id = " + pages[i].getId());
            text.append("\n----------");
            text.append("\n\ttitle = " + pages[i].getTitle());
            text.append("\n\tstyle = " + this.filterURL(pages[i].getStyle()));
            text.append("\n\talt-style = " + this.filterURL(pages[i].getAltStyle()));
            text.append("\n\tstyle-id = " + pages[i].getStyleId());
            this.printPageStyles(pages[i], text);
            this.printPageChildren(pages[i], text);
            ++i;
        }
    }

    private void printModelFlagTests(IntroModelRoot model, StringBuffer text) {
        text.append("Model Flag Tests: ");
        text.append("\n----------------");
        if (model.getPages().length == 0) {
            text.append("\nNo first page in model\n\n");
            return;
        }
        IntroPage firstPage = model.getPages()[0];
        text.append("\n\t\tFirst page children are: ");
        text.append("\n\t\t\tGroups: " + firstPage.getChildrenOfType(16).length);
        text.append("\n\t\t\tLinks: " + firstPage.getChildrenOfType(64).length);
        text.append("\n\t\t\tTexts: " + firstPage.getChildrenOfType(512).length);
        text.append("\n\t\t\tHTMLs: " + firstPage.getChildrenOfType(32).length);
        text.append("\n\t\t\tImages: " + firstPage.getChildrenOfType(128).length);
        text.append("\n\t\t\tIncludes: " + firstPage.getChildrenOfType(256).length);
        text.append("\n\t\t\tPage Titles: " + firstPage.getChildrenOfType(4096).length);
        text.append("\n\t\t\tPage Heads: " + firstPage.getChildrenOfType(2048).length);
        text.append("\n\t\t\tModel Elements: " + firstPage.getChildrenOfType(131071).length);
        text.append("\n\t\t\tContainers: " + firstPage.getChildrenOfType(29).length);
        text.append("\n\t\t\tAll Pages: " + firstPage.getChildrenOfType(12).length);
        text.append("\n\t\t\tAnchors: " + firstPage.getChildrenOfType(8192).length);
        text.append("\n\t\t\tContent providers: " + firstPage.getChildrenOfType(16384).length);
        text.append("\n\t\t\tElements with Text child(AbstractTextElemets): " + firstPage.getChildrenOfType(16480).length);
        AbstractIntroElement[] linksAndGroups = (AbstractIntroElement[])firstPage.getChildrenOfType(80);
        text.append("\n\t\t\tGroups and Links: " + linksAndGroups.length);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

