/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.provider;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.style.AnnotationStyleProvider;
import org.eclipse.papyrus.infra.emf.appearance.style.AppearanceStyleProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.CSSDOMSemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.StringHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CustomStyle;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class CSSCustomStyleDelegate
implements CustomStyle {
    private View view;
    private ExtendedCSSEngine engine;
    private Element element;
    private static final String NONE = "none";
    private static final String FULL = "full";
    private static int NONE_VALUE = 1000;
    private static int FULL_VALUE = 0;
    private static final AppearanceStyleProvider provider = new AnnotationStyleProvider();

    public CSSCustomStyleDelegate(View view, ExtendedCSSEngine engine) {
        this.view = CSSDOMSemanticElementHelper.getInstance().findPrimaryView((EObject)view);
        this.engine = engine;
        this.element = engine.getElement(this.view);
    }

    @Override
    public boolean showElementIcon() {
        EAnnotation displayNameLabelIcon = this.view.getEAnnotation("displayNameLabelIcon");
        if (displayNameLabelIcon != null) {
            return provider.showElementIcon((EModelElement)this.view);
        }
        CSSValue cssValue = this.engine.retrievePropertyValue(this.element, "elementIcon");
        if (cssValue == null) {
            return false;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public int getQualifiedNameDepth() {
        EAnnotation qualifiedNameAnnotation = this.view.getEAnnotation("QualifiedName");
        if (qualifiedNameAnnotation != null) {
            return provider.getQualifiedNameDepth((EModelElement)this.view);
        }
        CSSValue cssValue = this.engine.retrievePropertyValue(this.element, "qualifiedNameDepth");
        if (cssValue == null) {
            return NONE_VALUE;
        }
        String cssText = cssValue.getCssText();
        if (StringHelper.equals(FULL, cssText)) {
            return FULL_VALUE;
        }
        if (StringHelper.equals(NONE, cssText)) {
            return NONE_VALUE;
        }
        try {
            int value = Integer.parseInt(cssText);
            return value < 0 ? -value : value;
        }
        catch (NumberFormatException ex) {
            this.engine.handleExceptions(ex);
            return NONE_VALUE;
        }
    }

    @Override
    public boolean showShadow() {
        EAnnotation shadowAnnotation = this.view.getEAnnotation("ShadowFigure");
        if (shadowAnnotation != null) {
            return provider.showShadow((EModelElement)this.view);
        }
        CSSValue cssValue = this.engine.retrievePropertyValue(this.element, "shadow");
        if (cssValue == null) {
            return false;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }
}

