/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.ui.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ChoiceFigure
extends Figure {
    private int shape;
    private boolean visibility;

    public ChoiceFigure() {
        this.setShape(0);
        this.setVisibility(false);
        this.setMinimumSize(new Dimension(80, 60));
    }

    public void paint(Graphics graphics) {
        Rectangle r = this.getBounds();
        Color bg = graphics.getBackgroundColor();
        Color fg = graphics.getForegroundColor();
        int lw = graphics.getLineWidth();
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setForegroundColor(ColorConstants.black);
        Point p5 = new Point(r.x + r.width / 2, r.y + r.height / 2);
        Point p6 = new Point(r.x + 3 * r.width / 4, r.y + 3 * r.height / 4);
        Point p7 = new Point(r.x + r.width / 2, r.y + r.height);
        Point p8 = new Point(r.x + 1 * r.width / 4, r.y + 3 * r.height / 4);
        PointList pointList = new PointList();
        pointList.addPoint(p5);
        pointList.addPoint(p6);
        pointList.addPoint(p7);
        pointList.addPoint(p8);
        graphics.fillPolygon(pointList);
        graphics.setLineWidth(1);
        graphics.drawLine(p5, p6);
        graphics.drawLine(p6, p7);
        graphics.drawLine(p7, p8);
        graphics.drawLine(p5, p8);
        graphics.setBackgroundColor(bg);
        graphics.setForegroundColor(fg);
        Point p9 = new Point(r.x + r.width / 2, r.y);
        graphics.drawLine(p5, p9);
        graphics.setLineWidth(1);
        int radius = (r.width + r.height) / 22;
        Rectangle circle = new Rectangle(r.getCenter().x - radius, r.getCenter().y - 3 * radius, 2 * radius, 2 * radius);
        if (this.shape == 1) {
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawOval(circle);
            graphics.fillOval(circle);
        } else if (this.shape == 2) {
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawOval(circle);
            graphics.fillOval(circle);
        }
        graphics.setLineWidth(lw);
        super.paint(graphics);
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public int getShape() {
        return this.shape;
    }

    public void setVisibility(boolean p) {
        this.visibility = p;
    }

    public boolean getVisibility() {
        return this.visibility;
    }
}

