/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.extensionpoint;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.extensionpoint.IAddProfile;

public class AddProfileHandler {
    private static final String ADDPROFILE_ID = "org.polarsys.chess.addprofile";

    public void executeAddProfile(IExtensionRegistry registry, Model owner, ResourceSet resourceSet) {
        this.evaluateAddProfile(registry, owner, resourceSet);
    }

    private void evaluateAddProfile(IExtensionRegistry registry, Model owner, ResourceSet resourceSet) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(ADDPROFILE_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                System.out.println("Evaluating extension");
                Object o = e.createExecutableExtension("class");
                if (o instanceof IAddProfile) {
                    this.addProfile(o, owner, resourceSet);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
            Activator.error("evaluateAddProfile error", ex);
        }
    }

    private void addProfile(final Object o, final Model owner, final ResourceSet resourceSet) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                System.out.println("Exception in client");
                Activator.error("Exception in client", e);
            }

            public void run() throws Exception {
                ((IAddProfile)o).addProfile(owner, resourceSet);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    public void executeLoadProfile(IExtensionRegistry registry, ResourceSet resourceSet) {
        this.evaluateLoadProfile(registry, resourceSet);
    }

    private void evaluateLoadProfile(IExtensionRegistry registry, ResourceSet resourceSet) {
        IConfigurationElement[] config = registry.getConfigurationElementsFor(ADDPROFILE_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                System.out.println("Evaluating extension");
                Object o = e.createExecutableExtension("class");
                if (o instanceof IAddProfile) {
                    this.loadProfile(o, resourceSet);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
            Activator.error("EvaluateLoadProfile error", ex);
        }
    }

    private void loadProfile(final Object o, final ResourceSet resourceSet) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                System.out.println("Exception in client");
                Activator.error("Exception in client", e);
            }

            public void run() throws Exception {
                ((IAddProfile)o).loadProfile(resourceSet);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

