/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dataprovider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.papyrus.infra.nattable.filter.IFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.swt.widgets.Display;

public class FilterRowDataProvider<T>
implements IDataProvider {
    public static final String PIPE_REPLACEMENT = "\u00b0~\u00b0";
    public static final String FILTER_COLLECTION_PREFIX = "\u00b0coll(";
    private final IFilterStrategy<T> filterStrategy;
    private final ILayer columnHeaderLayer;
    private final IDataProvider columnHeaderDataProvider;
    private final INattableModelManager manager;
    private Map<Integer, Object> filterIndexToObjectMap = new HashMap<Integer, Object>();
    private Runnable refreshFilterRunnable;
    private AtomicBoolean isFilterRefreshing = new AtomicBoolean(false);

    public FilterRowDataProvider(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, INattableModelManager tableManager) {
        this.filterStrategy = filterStrategy;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.manager = tableManager;
    }

    public Map<Integer, Object> getFilterIndexToObjectMap() {
        return this.filterIndexToObjectMap;
    }

    public void setFilterIndexToObjectMap(Map<Integer, Object> filterIndexToObjectMap) {
        this.filterIndexToObjectMap = filterIndexToObjectMap;
    }

    public int getColumnCount() {
        return this.columnHeaderDataProvider.getColumnCount();
    }

    public void updateMapValue(int columnIndex) {
        Object mapValue;
        Object columnObject;
        Object savedValue;
        IFilterValueToMatchManager loader;
        NatTable natTable = (NatTable)this.manager.getAdapter(NatTable.class);
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        if (this.manager != null && (loader = this.getFilterValueToMatchManager(columnIndex)) != null && (savedValue = loader.getValueToMatch(configRegistry, columnObject = this.manager.getColumnElement(columnIndex))) != (mapValue = this.filterIndexToObjectMap.get(columnIndex)) && (mapValue != null && !mapValue.equals(savedValue) || savedValue != null && !savedValue.equals(mapValue))) {
            if (savedValue == null) {
                this.filterIndexToObjectMap.remove(columnIndex);
            } else {
                this.filterIndexToObjectMap.put(columnIndex, savedValue);
            }
            this.applyFilter();
        }
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.filterIndexToObjectMap.get(columnIndex);
    }

    protected void refreshFilterInUIThread() {
        NatTable natTable = this.getNatTable();
        if (natTable != null && natTable.isDisposed()) {
            return;
        }
        if (this.isFilterRefreshing.compareAndSet(false, true)) {
            this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
            this.columnHeaderLayer.fireLayerEvent((ILayerEvent)new FilterAppliedEvent(this.columnHeaderLayer));
            this.isFilterRefreshing.set(false);
        }
    }

    private Runnable createRefreshFilterRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (FilterRowDataProvider.this.refreshFilterRunnable != this) {
                        return;
                    }
                    FilterRowDataProvider.this.refreshFilterRunnable = null;
                }
                FilterRowDataProvider.this.refreshFilterInUIThread();
                ((NattableModelManager)FilterRowDataProvider.this.manager).refreshNatTable();
            }
        };
    }

    private NatTable getNatTable() {
        return (NatTable)this.manager.getAdapter(NatTable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter() {
        NatTable natTable = this.getNatTable();
        if (natTable != null && !natTable.isDisposed()) {
            Runnable schedule;
            FilterRowDataProvider filterRowDataProvider = this;
            synchronized (filterRowDataProvider) {
                if (this.refreshFilterRunnable == null) {
                    this.refreshFilterRunnable = schedule = this.createRefreshFilterRunnable();
                } else {
                    schedule = null;
                }
            }
            if (schedule != null) {
                Display display;
                NatTable control = natTable;
                Display display2 = display = control == null || control.isDisposed() ? null : control.getDisplay();
                if (display != null) {
                    display.asyncExec(schedule);
                }
            }
        }
    }

    public int getRowCount() {
        return 1;
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        IFilterValueToMatchManager loader;
        columnIndex = this.columnHeaderLayer.getColumnIndexByPosition(columnIndex);
        NatTable natTable = (NatTable)this.manager.getAdapter(NatTable.class);
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        if (this.manager != null && (loader = this.getFilterValueToMatchManager(columnIndex)) != null) {
            Object columnObject = this.manager.getColumnElement(columnIndex);
            loader.saveValueToMatch(configRegistry, columnObject, newValue);
        }
        if (ObjectUtils.isNotNull((Object)newValue)) {
            this.filterIndexToObjectMap.put(columnIndex, newValue);
        } else {
            this.filterIndexToObjectMap.remove(columnIndex);
        }
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        this.columnHeaderLayer.fireLayerEvent((ILayerEvent)new FilterAppliedEvent(this.columnHeaderLayer));
    }

    private IFilterValueToMatchManager getFilterValueToMatchManager(int columnIndex) {
        StringBuilder builder = new StringBuilder();
        builder.append("FILTER_COLUMN_");
        builder.append((Object)columnIndex);
        return (IFilterValueToMatchManager)this.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.FILTER_VALUE_TO_MATCH_MANAGER, "NORMAL", new String[]{builder.toString()});
    }

    private IConfigRegistry getConfigRegistry() {
        NatTable natTable = (NatTable)this.manager.getAdapter(NatTable.class);
        return natTable.getConfigRegistry();
    }

    private String getFilterStringRepresentation(Object filterValue, IDisplayConverter converter) {
        if (filterValue instanceof Collection) {
            String collectionSpec = FILTER_COLLECTION_PREFIX + filterValue.getClass().getName() + ")";
            StringBuilder builder = new StringBuilder(collectionSpec);
            builder.append("[");
            Collection filterCollection = (Collection)filterValue;
            Iterator iterator = filterCollection.iterator();
            while (iterator.hasNext()) {
                Object filterObject = iterator.next();
                builder.append(converter.canonicalToDisplayValue(filterObject));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
        return (String)converter.canonicalToDisplayValue(filterValue);
    }

    private Object getFilterFromString(String filterText, IDisplayConverter converter) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (filterText.startsWith(FILTER_COLLECTION_PREFIX)) {
            String[] filterSplit;
            int indexEndCollSpec = filterText.indexOf(")");
            String collectionSpec = filterText.substring(filterText.indexOf("(") + 1, indexEndCollSpec);
            Collection filterCollection = (Collection)Class.forName(collectionSpec).newInstance();
            filterText = filterText.substring(indexEndCollSpec + 2, filterText.length() - 1);
            String[] stringArray = filterSplit = filterText.split(",");
            int n = filterSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String filterString = stringArray[n2];
                filterCollection.add(converter.displayToCanonicalValue((Object)filterString));
                ++n2;
            }
            return filterCollection;
        }
        return converter.displayToCanonicalValue((Object)filterText);
    }

    public void clearAllFilters() {
        this.filterIndexToObjectMap.clear();
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        if (this.manager != null) {
            CompoundCommand cc = new CompoundCommand("Clear All Filter");
            TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(this.manager.getTable());
            List<Object> columnElement = this.manager.getColumnElementsList();
            for (Object current : columnElement) {
                Command cmd;
                if (!(current instanceof IAxis)) continue;
                NamedStyle idToDestroy = ((IAxis)current).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterId");
                NamedStyle keyToDestroy = ((IAxis)current).getNamedStyle(NattablestylePackage.eINSTANCE.getStyle(), "filterForcedByUserId");
                if (idToDestroy != null && (cmd = DeleteCommand.create((EditingDomain)domain, (Object)idToDestroy)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (idToDestroy == null || (cmd = DeleteCommand.create((EditingDomain)domain, (Object)keyToDestroy)) == null || !cmd.canExecute()) continue;
                cc.append(cmd);
            }
            if (!cc.isEmpty() && cc.canExecute()) {
                domain.getCommandStack().execute((Command)cc);
            }
        }
    }
}

