/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class TypeDropHelper
extends ElementHelper {
    public TypeDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropAsTypedElementType(DropObjectsRequest request, GraphicalEditPart host) {
        TypedElement typedElementDropTarget;
        CompoundCommand cc = new CompoundCommand("Set a new Type");
        IdentityCommand setCommand = null;
        Type newType = request.getObjects().get(0) instanceof Type ? (Type)request.getObjects().get(0) : null;
        TypedElement typedElement = typedElementDropTarget = this.getHostEObject(host) instanceof TypedElement ? (TypedElement)this.getHostEObject(host) : null;
        if (newType == null || typedElementDropTarget == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (newType == typedElementDropTarget.getType()) {
            setCommand = IdentityCommand.INSTANCE;
        }
        SetRequest req = new SetRequest((EObject)typedElementDropTarget, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)newType);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)UMLElementTypes.TYPED_ELEMENT);
        if (provider != null) {
            setCommand = provider.getEditCommand((IEditCommandRequest)req);
        }
        cc.add((Command)new ICommandProxy((ICommand)setCommand));
        return cc;
    }

    public Command getDropAsTypedPort(DropObjectsRequest request, GraphicalEditPart host) {
        CompoundCommand cc = new CompoundCommand("Create a new Port");
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidPortType(droppedEObject)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), this.getHostEObject(host), (IElementType)UMLElementTypes.PORT);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getHostEObject(host));
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    public Command getDropAsTypedPortOnPart(DropObjectsRequest request, GraphicalEditPart host) {
        CompoundCommand cc = new CompoundCommand("Create a new Port");
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidPortType(droppedEObject)) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject target = this.getHostEObject(host);
        if (!(target instanceof TypedElement) || ((TypedElement)target).getType() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Type targetType = ((TypedElement)target).getType();
        if (!((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)targetType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)targetType, (IElementType)UMLElementTypes.PORT);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetType);
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    public Command getDropAsTypedFlowPort(DropObjectsRequest request, GraphicalEditPart host, IElementType elementType) {
        CompoundCommand cc = new CompoundCommand("Create a new FlowPort (" + elementType.getDisplayName() + ")");
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidFlowPortType(droppedEObject, elementType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), this.getHostEObject(host), elementType);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getHostEObject(host));
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    public Command getDropAsTypedFlowPortOnPart(DropObjectsRequest request, GraphicalEditPart host, IElementType elementType) {
        CompoundCommand cc = new CompoundCommand("Create a new FlowPort (" + elementType.getDisplayName() + ")");
        Object droppedEObject = request.getObjects().get(0);
        if (!this.isValidFlowPortType(droppedEObject, elementType)) {
            return UnexecutableCommand.INSTANCE;
        }
        EObject target = this.getHostEObject(host);
        if (!(target instanceof TypedElement) || ((TypedElement)target).getType() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Type targetType = ((TypedElement)target).getType();
        if (!((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)targetType)) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createElementCommand = null;
        CreateElementRequest createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)targetType, elementType);
        createElementRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), request.getObjects().get(0)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetType);
        if (provider != null) {
            createElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        CreateElementRequestAdapter createElementRequestAdapter = new CreateElementRequestAdapter(createElementRequest);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)createElementRequestAdapter, Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(request.getLocation().getCopy());
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        cc.add((Command)new ICommandProxy(createElementCommand));
        cc.add(viewCreateCommand);
        return cc;
    }

    private boolean isValidFlowPortType(Object object, IElementType elementType) {
        boolean isValid = false;
        if (object != null && object instanceof Type) {
            Type type = (Type)object;
            if (type instanceof DataType) {
                isValid = true;
            }
            if (type instanceof Signal) {
                isValid = true;
            }
            if (((ISpecializationType)SysMLElementTypes.FLOW_SPECIFICATION).getMatcher().matches((EObject)type) && elementType == SysMLElementTypes.FLOW_PORT) {
                isValid = true;
            }
            if (((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)type)) {
                isValid = true;
            }
            if (((ISpecializationType)SysMLElementTypes.VALUE_TYPE).getMatcher().matches((EObject)type)) {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean isValidPortType(Object object) {
        boolean isValid = false;
        if (object != null && object instanceof Type && !(object instanceof Association)) {
            isValid = true;
        }
        return isValid;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

