/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.DashedEdgeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;

public class BasicEditPartProvider
extends AbstractEditPartProvider {
    private static final String DEBUG_PREFIX = "[EXPANSION_DIAGRAM]";
    private static final boolean DEBUG_EXPANSION = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.papyrus.infra.gmfdiag.common/debug/expansion"));
    protected Map<String, Class<?>> nodeMap = new HashMap();
    protected Map<String, Class<?>> edgeMap = new HashMap();

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateGraphicEditPartOperation && operation instanceof CreateGraphicEditPartOperation) {
            View newView = ((IEditPartOperation)operation).getView();
            if (newView == null) {
                return false;
            }
            try {
                if (ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)newView) == null) {
                    return false;
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return false;
            }
            String graphicalType = newView.getType();
            if (DEBUG_EXPANSION) {
                Activator.log.debug(DEBUG_PREFIX + ((Object)((Object)this)).getClass().getName() + " view appears with the type " + graphicalType);
            }
            return true;
        }
        return super.provides(operation);
    }

    public IGraphicalEditPart createGraphicEditPart(View view) {
        String graphicalType = view.getType();
        if (DEBUG_EXPANSION) {
            Activator.log.debug(DEBUG_PREFIX + ((Object)((Object)this)).getClass().getName() + " view appears with the type " + graphicalType);
        }
        IUMLEditPart graphicEditPart = null;
        if (view.eContainer() instanceof Diagram) {
            if (view instanceof Node && view.getElement() instanceof NamedElement) {
                graphicEditPart = new NamedElementEditPart(view){
                    protected NodeNamedElementFigure primaryShape;

                    @Override
                    protected void handleNotificationEvent(Notification event) {
                        if (this.resolveSemanticElement() != null) {
                            this.primaryShape.setName(((NamedElement)this.getNotationView().getElement()).getName());
                        }
                        super.handleNotificationEvent(event);
                    }

                    public IPapyrusNodeFigure getPrimaryShape() {
                        return this.primaryShape;
                    }

                    protected IFigure createNodePlate() {
                        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(100, 50);
                        return result;
                    }

                    protected IFigure createNodeShape() {
                        this.primaryShape = new NodeNamedElementFigure();
                        return this.primaryShape;
                    }

                    protected IFigure setupContentPane(IFigure nodeShape) {
                        if (nodeShape.getLayoutManager() == null) {
                            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
                            layout.setSpacing(5);
                            nodeShape.setLayoutManager((LayoutManager)layout);
                        }
                        return nodeShape;
                    }
                };
            } else if (view instanceof Edge && view.getElement() instanceof NamedElement) {
                graphicEditPart = new UMLConnectionNodeEditPart(view){

                    protected Connection createConnectionFigure() {
                        return new DashedEdgeFigure();
                    }

                    @Override
                    protected void handleNotificationEvent(Notification event) {
                        if (this.resolveSemanticElement() != null) {
                            this.getPrimaryShape().getAppliedStereotypeLabel().setBorder((Border)new LineBorder(new Color((Device)Display.getDefault(), new RGB(0, 255, 0))));
                            this.getPrimaryShape().getNameLabel().setBorder((Border)new LineBorder(new Color((Device)Display.getDefault(), new RGB(255, 0, 0))));
                            this.getPrimaryShape().getNameLabel().setText(((NamedElement)this.getNotationView().getElement()).getName());
                        }
                        super.handleNotificationEvent(event);
                    }

                    @Override
                    public DashedEdgeFigure getPrimaryShape() {
                        return (DashedEdgeFigure)this.getFigure();
                    }
                };
            }
        }
        if (!(view instanceof Diagram) && graphicEditPart == null) {
            return new GraphicalEditPart((EObject)view){

                protected IFigure createFigure() {
                    return new Figure();
                }

                protected void addNotationalListeners() {
                }

                protected void addSemanticListeners() {
                }
            };
        }
        return graphicEditPart;
    }
}

