/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.part.IPaletteDescription;
import org.eclipse.papyrus.uml.diagram.common.service.ExtendedPluginPaletteProvider;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.Activator;
import org.eclipse.papyrus.uml.diagram.paletteconfiguration.PaletteconfigurationPackage;

public class WorkspaceExtendedPaletteProvider
extends ExtendedPluginPaletteProvider
implements IPaletteProvider {
    protected boolean loadResourceExceptionLogged = false;

    public void setContributions(IPaletteDescription description) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Object paletteContributions = description.getContributions();
        this.contributions = Collections.emptyList();
        if (!(paletteContributions instanceof String)) {
            return;
        }
        Resource resource = this.loadResourceFromWorkspace((String)paletteContributions, (ResourceSet)resourceSet);
        if (resource != null) {
            try {
                resource.load(Collections.emptyMap());
                if (resource.getContents().size() > 0) {
                    this.contributions = new ArrayList(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration()));
                }
            }
            catch (IOException e) {
                if (!this.loadResourceExceptionLogged) {
                    Activator.log.debug("Impossible to load the resource for palette: " + description);
                    this.loadResourceExceptionLogged = true;
                }
                this.contributions = Collections.emptyList();
            }
        }
    }
}

