/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteDefinitionVisitor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPaletteDefinitionWalker
implements IPapyrusPaletteConstant {
    private final XMLPaletteDefinitionVisitor handler;

    public XMLPaletteDefinitionWalker(XMLPaletteDefinitionVisitor handler) {
        this.handler = handler;
    }

    public void walk(Node paletteDefinitionNode) {
        NodeList nodes = paletteDefinitionNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if ("content".equals(node.getNodeName())) {
                this.handler.onContent(node);
                this.walkContentNode(node);
            }
            ++i;
        }
    }

    private void walkContentNode(Node paletteContentNode) {
        NodeList nodes = paletteContentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if ("drawer".equals(name)) {
                this.walkDrawerNode(node);
            } else if ("stack".equals(name)) {
                this.walkStackNode(node);
            } else if ("separator".equals(name)) {
                this.walkSeparatorNode(node);
            } else if ("tool".equals(name)) {
                this.walkToolNode(node);
            } else if ("aspectTool".equals(name)) {
                this.walkAspectToolNode(node);
            }
            ++i;
        }
    }

    private void walkAspectToolNode(Node node) {
        this.handler.onAspectToolEntry(node);
    }

    private void walkDrawerNode(Node node) {
        this.handler.onDrawer(node);
        if (node.getChildNodes().getLength() > 0) {
            this.walkContentNode(node);
        }
    }

    private void walkStackNode(Node node) {
        this.handler.onStack(node);
        if (node.getChildNodes().getLength() > 0) {
            this.walkContentNode(node);
        }
    }

    private void walkToolNode(Node node) {
        this.handler.onToolEntry(node);
        if (node.getChildNodes().getLength() > 0) {
            this.walkContentNode(node);
        }
    }

    private void walkSeparatorNode(Node node) {
        this.handler.onSeparator(node);
        if (node.getChildNodes().getLength() > 0) {
            this.walkContentNode(node);
        }
    }
}

