/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolProviderConfiguration;
import org.eclipse.papyrus.uml.diagram.common.service.palette.GetAllAspectToolProvidersOperation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.GetAspectToolProviderOperation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectToolProviderService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypeAspectActionProvider;
import org.w3c.dom.Node;

public class AspectToolService
extends Service
implements IAspectToolProviderService {
    protected static final AspectToolService instance = new AspectToolService();

    static {
        instance.configureProviders("org.eclipse.papyrus.uml.diagram.common", "aspectToolProvider");
    }

    public static AspectToolService getInstance() {
        return instance;
    }

    protected AspectToolService() {
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    @Override
    public List<IAspectActionProvider> getProviders() {
        ArrayList<IAspectActionProvider> providers = new ArrayList<IAspectActionProvider>();
        this.execute(ExecutionStrategy.REVERSE, new GetAllAspectToolProvidersOperation(providers));
        return providers;
    }

    @Override
    public IAspectActionProvider getProvider(String id) {
        List providers = this.execute(ExecutionStrategy.REVERSE, new GetAspectToolProviderOperation(id));
        if (providers == null) {
            return new StereotypeAspectActionProvider();
        }
        for (IAspectActionProvider aspectActionProvider : providers) {
            if (aspectActionProvider == null) continue;
            return aspectActionProvider;
        }
        return new StereotypeAspectActionProvider();
    }

    public static String getProviderId(Node actionNode) {
        String id = "";
        Node node = actionNode.getAttributes().getNamedItem("id");
        if (node == null) {
            return "org.eclipse.papyrus.applystereotypeactionprovider";
        }
        id = node.getNodeValue();
        return id;
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        protected AspectToolProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = AspectToolProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (operation instanceof GetAllAspectToolProvidersOperation) {
                return true;
            }
            if (operation instanceof GetAspectToolProviderOperation) {
                return this.providerConfiguration.getId().equals(((GetAspectToolProviderOperation)operation).getIdentifier());
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IAspectActionProvider) {
                    IAspectActionProvider defaultProvider = (IAspectActionProvider)newProvider;
                    defaultProvider.setConfiguration(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

