/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.IErrorHandler;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalBuffer;

public class Buffer
implements InternalBuffer {
    public static final int MAKE_PAYLOAD_SIZE_NON_ZERO = 1;
    private static final byte FLAG_EOS = 1;
    private static final byte FLAG_CCAM = 2;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER, Buffer.class);
    private static int lastID;
    private int id = ++lastID;
    private IErrorHandler errorHandler;
    private IBufferProvider bufferProvider;
    private short channelID;
    private byte flags;
    private BufferState state = BufferState.INITIAL;
    private ByteBuffer byteBuffer;

    public Buffer(IBufferProvider provider, short capacity) {
        this.bufferProvider = provider;
        this.byteBuffer = ByteBuffer.allocateDirect(capacity);
    }

    public boolean isEOS() {
        return (this.flags & 1) != 0;
    }

    public void setEOS(boolean eos) {
        this.flags = eos ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isCCAM() {
        return (this.flags & 2) != 0;
    }

    public void setCCAM(boolean ccam) {
        this.flags = ccam ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    public void setBufferProvider(IBufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    public short getChannelID() {
        if (this.state == BufferState.INITIAL || this.state == BufferState.READING_HEADER) {
            throw new IllegalStateException(this.toString());
        }
        return this.channelID;
    }

    public void setChannelID(short channelID) {
        this.channelID = channelID;
    }

    public short getCapacity() {
        return (short)this.byteBuffer.capacity();
    }

    public BufferState getState() {
        return this.state;
    }

    public void setState(BufferState state) {
        this.state = state;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer buffer) {
        this.byteBuffer = buffer;
    }

    public void clear() {
        this.state = BufferState.INITIAL;
        this.channelID = Short.MIN_VALUE;
        this.flags = 0;
        this.byteBuffer.clear();
    }

    public void release() {
        if (this.state != BufferState.RELEASED) {
            this.state = BufferState.RELEASED;
            this.errorHandler = null;
            if (this.bufferProvider != null) {
                this.bufferProvider.retainBuffer(this);
            }
        }
    }

    public void dispose() {
        this.state = BufferState.DISPOSED;
        this.bufferProvider = null;
        this.byteBuffer = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer startGetting(SocketChannel socketChannel) throws IOException {
        try {
            if (this.state != BufferState.INITIAL && this.state != BufferState.READING_HEADER && this.state != BufferState.READING_BODY) {
                throw new IllegalStateException(this.toString());
            }
            if (this.state == BufferState.INITIAL) {
                this.byteBuffer.limit(4);
                this.state = BufferState.READING_HEADER;
            }
            if (this.state == BufferState.READING_HEADER) {
                Buffer.readChannel(socketChannel, this.byteBuffer);
                if (this.byteBuffer.hasRemaining()) {
                    return null;
                }
                this.byteBuffer.flip();
                this.channelID = this.byteBuffer.getShort();
                short payloadSize = this.byteBuffer.getShort();
                if (payloadSize < 0) {
                    this.setEOS(true);
                    payloadSize = -payloadSize;
                }
                payloadSize = (short)(payloadSize - 1);
                this.byteBuffer.clear();
                try {
                    this.byteBuffer.limit(payloadSize);
                }
                catch (IllegalArgumentException ex) {
                    String string;
                    if (payloadSize < 0) {
                        String string2;
                        StringBuilder stringBuilder = new StringBuilder("New limit ").append(payloadSize).append(" is < 0");
                        if (this.isEOS()) {
                            string2 = " (EOS)";
                            throw new IllegalArgumentException(stringBuilder.append(string2).toString(), ex);
                        }
                        string2 = "";
                        throw new IllegalArgumentException(stringBuilder.append(string2).toString(), ex);
                    }
                    int capacity = this.byteBuffer.capacity();
                    if (payloadSize <= capacity) throw ex;
                    StringBuilder stringBuilder = new StringBuilder("New limit ").append(payloadSize).append(" is > ").append(capacity);
                    if (this.isEOS()) {
                        string = " (EOS)";
                        throw new IllegalArgumentException(stringBuilder.append(string).toString(), ex);
                    }
                    string = "";
                    throw new IllegalArgumentException(stringBuilder.append(string).toString(), ex);
                }
                this.state = BufferState.READING_BODY;
            }
            Buffer.readChannel(socketChannel, this.byteBuffer);
            if (this.byteBuffer.hasRemaining()) {
                return null;
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Read " + this.byteBuffer.limit() + " bytes" + (this.isEOS() ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
            }
            this.byteBuffer.flip();
            this.state = BufferState.GETTING;
            return this.byteBuffer;
        }
        catch (IOException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public ByteBuffer startPutting(short channelID) {
        try {
            if (this.state == BufferState.PUTTING) {
                if (channelID != this.channelID) {
                    throw new IllegalArgumentException("channelID != this.channelID");
                }
            } else {
                if (this.state != BufferState.INITIAL) {
                    throw new IllegalStateException("state: " + (Object)((Object)this.state));
                }
                this.state = BufferState.PUTTING;
                this.channelID = channelID;
                this.byteBuffer.clear();
                this.byteBuffer.position(4);
            }
            return this.byteBuffer;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public boolean write(SocketChannel socketChannel) throws IOException {
        block13: {
            int numBytes;
            block12: {
                if (this.byteBuffer.position() != 4) break block12;
                this.clear();
                return true;
            }
            if (this.state != BufferState.PUTTING && this.state != BufferState.WRITING) {
                throw new IllegalStateException(this.toString());
            }
            if (this.state == BufferState.PUTTING) {
                if (this.channelID == Short.MIN_VALUE) {
                    throw new IllegalStateException("channelID == NO_CHANNEL");
                }
                int payloadSize = this.byteBuffer.position() - 4 + 1;
                boolean eos = this.isEOS();
                if (eos) {
                    payloadSize = -payloadSize;
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Writing " + (Math.abs(payloadSize) - 1) + " bytes" + (eos ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
                }
                this.byteBuffer.flip();
                this.byteBuffer.putShort(this.channelID);
                this.byteBuffer.putShort((short)payloadSize);
                this.byteBuffer.position(0);
                this.state = BufferState.WRITING;
            }
            if ((numBytes = socketChannel.write(this.byteBuffer)) == -1) {
                throw new IOException("Channel closed");
            }
            if (!this.byteBuffer.hasRemaining()) break block13;
            return false;
        }
        try {
            this.clear();
            return true;
        }
        catch (IOException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public void flip() {
        try {
            if (this.state != BufferState.PUTTING) {
                throw new IllegalStateException(this.toString());
            }
            this.byteBuffer.flip();
            this.byteBuffer.position(4);
            this.state = BufferState.GETTING;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public String toString() {
        return MessageFormat.format("Buffer@{0}[{1}]", new Object[]{this.id, this.state});
    }

    public String formatContent(boolean showHeader) {
        int oldPosition = this.byteBuffer.position();
        int oldLimit = this.byteBuffer.limit();
        try {
            if (this.state != BufferState.GETTING) {
                this.byteBuffer.flip();
            }
            if (this.state == BufferState.PUTTING && !showHeader) {
                this.byteBuffer.position(4);
            }
            StringBuilder builder = new StringBuilder();
            while (this.byteBuffer.hasRemaining()) {
                int b = this.byteBuffer.get();
                HexUtil.appendHex((StringBuilder)builder, (int)(b < 0 ? ~b : b));
                builder.append(' ');
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.byteBuffer.position(oldPosition);
            this.byteBuffer.limit(oldLimit);
        }
    }

    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void handleError(Throwable t) {
        try {
            if (this.errorHandler != null) {
                this.errorHandler.handleError(t);
            } else if (TRACER.isEnabled()) {
                TRACER.trace(t);
            }
        }
        finally {
            this.release();
        }
    }

    private static void readChannel(SocketChannel socketChannel, ByteBuffer buffer) throws ClosedChannelException {
        try {
            if (socketChannel.read(buffer) == -1) {
                throw new IOException("Channel has reached end-of-stream");
            }
        }
        catch (ClosedChannelException ex) {
            throw ex;
        }
        catch (IOException ex) {
            ClosedChannelException exception = new ClosedChannelException();
            exception.initCause(ex);
            throw exception;
        }
    }

    private static String formatHex(String hex) {
        StringBuilder builder = new StringBuilder();
        int length = hex.length();
        int i = 0;
        while (i < length) {
            builder.append(hex.charAt(i));
            if (i % 2 == 1 && i < length - 1) {
                builder.append(' ');
            }
            ++i;
        }
        return builder.toString();
    }

    private static void decodeBuffer(String hex) throws IOException {
        System.out.println("Buffer: " + Buffer.formatHex(hex));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(HexUtil.hexToBytes((String)hex)));
        short channelID = in.readShort();
        boolean eos = false;
        short payloadSize = in.readShort();
        if (payloadSize < 0) {
            payloadSize = -payloadSize;
            eos = true;
        }
        payloadSize = (short)(payloadSize - 1);
        System.out.println("channelID:     " + channelID);
        System.out.println("payloadSize:   " + payloadSize);
        System.out.println("eos:           " + eos);
        String type = "request";
        int correlationID = in.readInt();
        if (correlationID < 0) {
            correlationID = -correlationID;
            type = "response";
        } else if (in.available() >= 2) {
            short signalID = in.readShort();
            System.out.println("signalID:      " + signalID);
        }
        System.out.println("correlationID: " + correlationID);
        System.out.println("type:          " + type);
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        Buffer.decodeBuffer("0001ffea0000026b001a0000000101ff000000000000058d00");
        Buffer.decodeBuffer("0001fffafffffd9500");
        Buffer.decodeBuffer("0001ffea00000064001a0000000101ff000000000000040c00");
        Buffer.decodeBuffer("0001fffaffffff9c00");
    }
}

