/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;

public class UMLMetaclassContentProvider
extends AbstractFilteredContentProvider
implements IStaticContentProvider {
    private final List<Class> possibleMetaclasses;

    public UMLMetaclassContentProvider(Element element) {
        this.possibleMetaclasses = ElementUtil.getPossibleMetaclasses((Element)element);
        this.sortPossibleMetaClasses();
    }

    private void sortPossibleMetaClasses() {
        Collections.sort(this.possibleMetaclasses, new Comparator<Class>(){

            @Override
            public int compare(Class firstClass, Class secondClass) {
                String firstName = firstClass.getName();
                if (firstName == null) {
                    return 0;
                }
                return firstName.compareTo(secondClass.getName());
            }
        });
    }

    public Object[] getElements() {
        return this.possibleMetaclasses.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }
}

