/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.executors;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.eclipse.opencert.storage.cdo.session.ICDOSessionProvider;
import org.eclipse.opencert.storage.cdo.session.SimpleCDOSessionProvider;

public abstract class SimpleInTransactionExecutor {
    private final ICDOSessionProvider cdoSessionProvider = new SimpleCDOSessionProvider(OpencertPropertiesReader.getInstance());

    public abstract void executeInTransaction(CDOTransaction var1);

    public void executeReadOnlyOperation() {
        try {
            CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
            CDOTransaction cdoTransaction = activeSession.openTransaction();
            this.executeInTransaction(cdoTransaction);
            cdoTransaction.rollback();
        }
        finally {
            this.cdoSessionProvider.close();
        }
    }

    public void executeReadWriteOperation() {
        try {
            CDOSession activeSession = this.cdoSessionProvider.getActiveSession();
            CDOTransaction cdoTransaction = activeSession.openTransaction();
            this.executeInTransaction(cdoTransaction);
            try {
                cdoTransaction.commit();
            }
            catch (CommitException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.cdoSessionProvider.close();
        }
    }
}

