/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.test;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.storage.cdo.StandaloneCDOAccessor;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.eclipse.opencert.storage.cdo.test.SampleDataProvider;

public class SampleDataPopulator {
    public static void main(String[] args) {
        SampleDataPopulator sampleDataPopulator = new SampleDataPopulator();
        sampleDataPopulator.populateWithArtefactHierarchy();
        sampleDataPopulator.populateMandatoryHierarchiesForEmptyDatabase();
    }

    public void populateWithArtefactHierarchy() {
        StandaloneCDOAccessor standaloneCDOAccessor = StandaloneCDOAccessor.getStandaloneCDOAccessor(OpencertPropertiesReader.getInstance());
        try (CDOSession cdoSession = null;){
            try {
                cdoSession = standaloneCDOAccessor.openSession();
                CDOTransaction transaction = cdoSession.openTransaction();
                Resource resource = StandaloneCDOAccessor.getDefaultResource(transaction);
                SampleDataProvider.populateWithArtefactHierarchy(resource);
                transaction.setCommitComment("populateWithArtefactHierarchy()");
                transaction.commit();
                transaction.getSession().close();
            }
            catch (CommitException e) {
                e.printStackTrace();
                cdoSession.close();
            }
        }
    }

    public void populateMandatoryHierarchiesForEmptyDatabase() {
        StandaloneCDOAccessor standaloneCDOAccessor = StandaloneCDOAccessor.getStandaloneCDOAccessor(OpencertPropertiesReader.getInstance());
        try (CDOSession cdoSession = null;){
            try {
                cdoSession = standaloneCDOAccessor.openSession();
                CDOTransaction transaction = cdoSession.openTransaction();
                Resource resource = StandaloneCDOAccessor.getDefaultResource(transaction);
                SampleDataProvider.populateArg(resource);
                SampleDataProvider.populateAssuranceProject(resource);
                transaction.setCommitComment("populateAssuranceProject");
                transaction.commit();
                transaction.getSession().close();
            }
            catch (CommitException e) {
                e.printStackTrace();
                cdoSession.close();
            }
        }
    }

    public void updateArtefact() {
        StandaloneCDOAccessor standaloneCDOAccessor = StandaloneCDOAccessor.getStandaloneCDOAccessor(OpencertPropertiesReader.getInstance());
        try (CDOSession cdoSession = null;){
            try {
                cdoSession = standaloneCDOAccessor.openSession();
                CDOTransaction transaction = cdoSession.openTransaction();
                CDOQuery cqo = transaction.createQuery("sql", "select * from evidence_Artefact where id ilike '0'");
                Artefact artefact = (Artefact)cqo.getResultValue(Artefact.class);
                artefact.setName(String.valueOf(artefact.getName()) + "_updated_" + 2);
                transaction.setCommitComment("Changing name of artefact");
                transaction.commit();
            }
            catch (CommitException e) {
                e.printStackTrace();
                cdoSession.close();
            }
        }
    }
}

