/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineCreationWizard;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineDiagramEditorPlugin;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.DawnBaselineDiagramEditorUtil;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DawnBaselineCreationWizard
extends BaselineCreationWizard {
    private CDOView view;
    private DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    private DawnCreateNewResourceWizardPage dawnDomainModelFilePage;

    public DawnBaselineCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                URI diagramResourceURI = DawnBaselineCreationWizard.this.dawnDiagramModelFilePage.getURI();
                URI domainModelResourceURI = DawnBaselineCreationWizard.this.dawnDomainModelFilePage.getURI();
                DawnBaselineCreationWizard.this.diagram = DawnBaselineDiagramEditorUtil.createDiagram(diagramResourceURI, domainModelResourceURI, monitor);
                if (DawnBaselineCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DawnBaselineCreationWizard.this.diagram != null) {
                    try {
                        DawnBaselineDiagramEditorUtil.openDiagram(DawnBaselineCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnBaselineCreationWizard.this.getContainer().getShell(), (String)Messages.BaselineCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.BaselineCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                BaselineDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage("baseline_diagram", false, this.view);
        this.dawnDiagramModelFilePage.setTitle(Messages.BaselineCreationWizard_DiagramModelFilePageTitle);
        this.dawnDiagramModelFilePage.setDescription(Messages.BaselineCreationWizard_DiagramModelFilePageDescription);
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage("baseline", false, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnBaselineCreationWizard.this.dawnDiagramModelFilePage.getURI();
                    String fileName = uri.lastSegment();
                    fileName = fileName.substring(0, fileName.length() - ".baseline_diagram".length());
                    fileName = String.valueOf(fileName) + ".baseline";
                    DawnBaselineCreationWizard.this.dawnDomainModelFilePage.setResourceNamePrefix(fileName);
                    DawnBaselineCreationWizard.this.dawnDomainModelFilePage.setResourcePath(DawnBaselineCreationWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle(Messages.BaselineCreationWizard_DomainModelFilePageTitle);
        this.dawnDomainModelFilePage.setDescription(Messages.BaselineCreationWizard_DomainModelFilePageDescription);
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public void dispose() {
        this.view.close();
    }
}

