/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityParameterNodeParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String UNTYPED_PARAMETER_FORMAT = "%s";
    private static final String TYPED_PARAMETER_FORMAT = "%s: %s";
    private static final String STATE_FORMAT = System.getProperty("line.separator").concat("[%s]");
    private static final String STATE_SEPARATOR = ", ";

    public ActivityParameterNodeParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    public ActivityParameterNodeParser(EAttribute[] features) {
        super(features);
    }

    public ActivityParameterNodeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String result = "";
        ActivityParameterNode parameterNode = null;
        Object adapter = element.getAdapter(EObject.class);
        if (adapter instanceof ActivityParameterNode) {
            parameterNode = (ActivityParameterNode)adapter;
            String name = parameterNode.getName();
            result = String.format(UNTYPED_PARAMETER_FORMAT, name);
            if (parameterNode.getType() != null) {
                String type = parameterNode.getType().getName();
                result = String.format(TYPED_PARAMETER_FORMAT, name, type);
            }
            StringBuffer stateLabel = new StringBuffer();
            for (State state : parameterNode.getInStates()) {
                String stateName = state.getName();
                if (stateName == null) {
                    stateName = "";
                }
                if ("".equals(stateName)) continue;
                if (stateLabel.length() > 0) {
                    stateLabel.append(STATE_SEPARATOR);
                }
                stateLabel.append(stateName);
            }
            if (stateLabel.length() > 0) {
                result = String.valueOf(result) + String.format(STATE_FORMAT, stateLabel.toString());
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        ActivityParameterNode parameterNode = null;
        if (element instanceof ActivityParameterNode) {
            parameterNode = (ActivityParameterNode)element;
            semanticElementsBeingParsed.add(parameterNode);
            if (parameterNode.getType() != null) {
                semanticElementsBeingParsed.add(parameterNode.getType());
            }
            if (parameterNode.getInStates() != null && !parameterNode.getInStates().isEmpty()) {
                semanticElementsBeingParsed.addAll((Collection<Object>)parameterNode.getInStates());
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getObjectNode_InState().equals(feature);
    }
}

