/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class ParameterParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String TYPED_PARAMETER_FORMAT = "%s: %s";
    private static final String UNTYPED_PARAMETER_FORMAT = "%s";

    public ParameterParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public ParameterParser(EAttribute[] features) {
        super(features);
    }

    public ParameterParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof Parameter) {
            Parameter parameter = (Parameter)obj;
            String name = parameter.getName();
            if (name == null) {
                name = " ";
            }
            if (parameter.getType() != null) {
                String type = parameter.getType().getName();
                if (type == null) {
                    type = "";
                }
                return String.format(TYPED_PARAMETER_FORMAT, name, type);
            }
            return String.format(UNTYPED_PARAMETER_FORMAT, name);
        }
        return " ";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof Parameter) {
            Parameter parameter = (Parameter)element;
            semanticElementsBeingParsed.add(parameter);
            if (parameter.getType() != null) {
                semanticElementsBeingParsed.add(parameter.getType());
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature);
    }
}

